/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.sync.sync.progress;

import io.accelerate.tracking.sync.sync.progress.ProgressListener;
import java.io.File;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;

public class UploadStatsProgressListener
implements ProgressListener {
    private FileUploadStat fileUploadStat = null;

    @Override
    public void uploadFileStarted(File file, String uploadId, long uploadedByte) {
        this.fileUploadStat = new FileUploadStat(file.length(), uploadedByte);
    }

    @Override
    public void uploadFileProgress(String uploadId, long uploadedByte) {
        this.fileUploadStat.incrementUploadedSize(uploadedByte);
    }

    @Override
    public void uploadFileFinished(File file) {
        this.fileUploadStat = null;
    }

    public Optional<FileUploadStat> getCurrentStats() {
        return Optional.ofNullable(this.fileUploadStat);
    }

    public boolean isCurrentlyUploading() {
        return this.fileUploadStat != null;
    }

    public static class FileUploadStat {
        private final double BYTE_PER_MILLISECOND_TO_MEGABYTES_PER_SECOND = 0.001;
        private long totalSize = 0L;
        private final AtomicLong uploadedSize;
        private long startTimestamp = 0L;

        FileUploadStat(long totalSize, long uploadedByte) {
            this.totalSize = totalSize;
            this.startTimestamp = new Date().getTime();
            this.uploadedSize = new AtomicLong(uploadedByte);
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public long getUploadedSize() {
            return this.uploadedSize.get();
        }

        void incrementUploadedSize(long size) {
            this.uploadedSize.getAndAdd(size);
        }

        public double getMBps() {
            double elapsedMilliseconds = new Date().getTime() - this.startTimestamp;
            if (elapsedMilliseconds == 0.0) {
                return 0.0;
            }
            double bytesUploaded = this.uploadedSize.get();
            double bytePerMillisecond = bytesUploaded / elapsedMilliseconds;
            return bytePerMillisecond * 0.001;
        }

        public double getUploadRatio() {
            return (double)this.uploadedSize.get() / (double)this.totalSize;
        }
    }
}

