/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.sync.upload;

import io.accelerate.tracking.sync.helpers.FileHelper;
import io.accelerate.tracking.sync.sync.SyncException;
import io.accelerate.tracking.sync.upload.FileUploader;
import io.accelerate.tracking.sync.upload.UploadingException;
import io.accelerate.tracking.sync.upload.UploadingStrategy;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploaderImpl
implements FileUploader {
    private static final Logger log = LoggerFactory.getLogger(FileUploaderImpl.class);
    private static final int RETRY_TIMES_COUNT = 2;
    private final UploadingStrategy uploadingStrategy;

    FileUploaderImpl(UploadingStrategy uploadingStrategy) {
        this.uploadingStrategy = uploadingStrategy;
    }

    @Override
    public void upload(File file) throws UploadingException {
        this.upload(file, file.getName());
    }

    @Override
    public void upload(File file, String path) throws UploadingException {
        this.upload(file, path, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(File file, String path, int retry) throws UploadingException {
        String filePath = FileHelper.getRelativeFilePathToCwd(file);
        log.info("Uploading file " + filePath);
        try {
            this.uploadInternal(file, path);
        }
        catch (SyncException | IOException e) {
            if (retry == 0) {
                log.error("Error during uploading, can't upload file due to exception: " + e.getMessage());
                throw new UploadingException("Can't upload file " + filePath + " due to error " + e.getMessage(), e);
            }
            log.warn("Error during uploading : " + e.getMessage() + " Trying next time...");
            this.upload(file, path, retry - 1);
        }
        finally {
            log.info("Finished uploading file " + filePath);
        }
    }

    private void uploadInternal(File file, String path) throws SyncException, IOException {
        this.uploadingStrategy.upload(file, path);
    }
}

