/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.sync.upload;

import io.accelerate.tracking.sync.sync.progress.ProgressListener;
import io.accelerate.tracking.sync.upload.FileUploader;
import io.accelerate.tracking.sync.upload.FileUploaderImpl;
import io.accelerate.tracking.sync.upload.MultipartUploadingStrategy;
import io.accelerate.tracking.sync.upload.UploadingException;
import io.accelerate.tracking.sync.upload.UploadingStrategy;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.awssdk.services.s3.S3AsyncClient;

public class FileUploadingService {
    private final UploadingStrategy uploadingStrategy;
    private final FileUploader fileUploader;

    public FileUploadingService(S3AsyncClient s3AsyncClient, String bucket, String prefix) {
        this.uploadingStrategy = new MultipartUploadingStrategy(s3AsyncClient, bucket, prefix);
        this.fileUploader = new FileUploaderImpl(this.uploadingStrategy);
    }

    public void setListener(ProgressListener listener) {
        this.uploadingStrategy.setListener(listener);
    }

    public void upload(File file) {
        this.upload(file, file.getName());
    }

    public void upload(File sourceFile, String remoteFileName) {
        try {
            this.fileUploader.upload(sourceFile, remoteFileName);
        }
        catch (UploadingException ex) {
            Logger.getLogger(FileUploadingService.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

