/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.sync.upload;

import io.accelerate.tracking.sync.helpers.FileHelper;
import io.accelerate.tracking.sync.helpers.FormattingHelper;
import io.accelerate.tracking.sync.sync.SyncException;
import io.accelerate.tracking.sync.sync.progress.ProgressListener;
import io.accelerate.tracking.sync.upload.UploadingStrategy;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.s3.model.ListPartsRequest;
import software.amazon.awssdk.services.s3.model.ListPartsResponse;
import software.amazon.awssdk.services.s3.model.MultipartUpload;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.Part;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;

public class MultipartUploadingStrategy
implements UploadingStrategy,
Closeable {
    private static final long PART_SIZE_BYTES = 0x500000L;
    private static final int MAX_CONCURRENCY = 4;
    private static final int STREAM_CHUNK_SIZE = 262144;
    private final S3AsyncClient s3;
    private final String bucket;
    private final String prefix;
    private volatile ProgressListener listener;

    public MultipartUploadingStrategy(S3AsyncClient s3, String bucket, String prefix) {
        this.s3 = Objects.requireNonNull(s3, "s3");
        this.bucket = Objects.requireNonNull(bucket, "bucket");
        this.prefix = prefix == null ? "" : prefix;
    }

    @Override
    public void setListener(ProgressListener listener) {
        this.listener = listener;
    }

    @Override
    public void upload(File file, String remoteFileName) throws SyncException, IOException {
        long lastPartSizeThisRun;
        int maxPartNumberThisRun;
        Objects.requireNonNull(file, "file");
        if (!file.exists() || !file.isFile()) {
            throw new IOException("File does not exist or is not a regular file: " + String.valueOf(file));
        }
        Objects.requireNonNull(remoteFileName, "remoteFileName");
        String key = FormattingHelper.buildKey(this.prefix, remoteFileName);
        if (this.objectExists(this.bucket, key)) {
            return;
        }
        Path source = file.toPath();
        long initialSize = Files.size(source);
        boolean lockExists = FileHelper.lockFileExists(file);
        long fullPartsAvailable = initialSize / 0x500000L;
        long totalPartsIfUnlocked = (initialSize + 0x500000L - 1L) / 0x500000L;
        UploadSession session = this.resolveOrCreateUploadId(this.bucket, key);
        List<Part> existingParts = this.listAllParts(this.bucket, key, session.uploadId());
        Map<Integer, ExistingPart> existingEtagsByPart = existingParts.stream().collect(Collectors.toMap(Part::partNumber, p -> new ExistingPart(FormattingHelper.sanitizeETag(p.eTag()), p.checksumSHA256())));
        long alreadyUploadedBytes = existingParts.stream().mapToLong(Part::size).sum();
        ProgressListener l = this.listener;
        if (l != null) {
            try {
                l.uploadFileStarted(file, session.uploadId(), alreadyUploadedBytes);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (lockExists) {
            maxPartNumberThisRun = (int)fullPartsAvailable;
            lastPartSizeThisRun = 0x500000L;
        } else {
            maxPartNumberThisRun = (int)totalPartsIfUnlocked;
            if (initialSize == 0L) {
                if (this.listener != null) {
                    try {
                        this.listener.uploadFileFinished(file);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return;
            }
            long remainder = initialSize - 0x500000L * (totalPartsIfUnlocked - 1L);
            lastPartSizeThisRun = remainder == 0L ? 0x500000L : remainder;
        }
        List targetPartNumbers = IntStream.rangeClosed(1, maxPartNumberThisRun).boxed().collect(Collectors.toList());
        List missingPartNumbers = targetPartNumbers.stream().filter(pn -> !existingEtagsByPart.containsKey(pn)).collect(Collectors.toList());
        List newCompletedParts = Collections.synchronizedList(new ArrayList());
        ArrayList<CompletionStage> inFlight = new ArrayList<CompletionStage>();
        AtomicLong uploadedSoFar = new AtomicLong(alreadyUploadedBytes);
        try {
            for (Integer partNumber : missingPartNumbers) {
                long size;
                while (inFlight.size() >= 4) {
                    CompletableFuture.anyOf(inFlight.toArray(new CompletableFuture[0])).join();
                    inFlight.removeIf(CompletableFuture::isDone);
                }
                long offset = (long)(partNumber - 1) * 0x500000L;
                long l2 = size = partNumber == maxPartNumberThisRun ? lastPartSizeThisRun : 0x500000L;
                if (size <= 0L) continue;
                String sha256Base64 = MultipartUploadingStrategy.computeSha256Base64(source, offset, size);
                UploadPartRequest req = (UploadPartRequest)UploadPartRequest.builder().bucket(this.bucket).key(key).uploadId(session.uploadId()).partNumber(partNumber).contentLength(Long.valueOf(size)).checksumSHA256(sha256Base64).build();
                FileSlicePublisher slice = new FileSlicePublisher(source, offset, size, 262144);
                AsyncRequestBody body = AsyncRequestBody.fromPublisher((Publisher)slice);
                CompletionStage fut = this.s3.uploadPart(req, body).thenApply(resp -> {
                    newCompletedParts.add((CompletedPart)CompletedPart.builder().partNumber(partNumber).checksumSHA256(sha256Base64).eTag(FormattingHelper.sanitizeETag(resp.eTag())).build());
                    long current = uploadedSoFar.addAndGet(size);
                    ProgressListener pl = this.listener;
                    if (pl != null) {
                        try {
                            pl.uploadFileProgress(session.uploadId(), current);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return resp;
                });
                inFlight.add(fut);
            }
            if (!inFlight.isEmpty()) {
                CompletableFuture.allOf(inFlight.toArray(new CompletableFuture[0])).join();
            }
            if (lockExists) {
                return;
            }
            ArrayList<CompletedPart> allParts = new ArrayList<CompletedPart>(maxPartNumberThisRun);
            for (int pn2 = 1; pn2 <= maxPartNumberThisRun; ++pn2) {
                int partNum = pn2;
                ExistingPart existingPart = existingEtagsByPart.get(partNum);
                if (existingPart != null) {
                    allParts.add((CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(partNum)).checksumSHA256(existingPart.checksumSHA256).eTag(existingPart.eTag).build());
                    continue;
                }
                CompletedPart p2 = newCompletedParts.stream().filter(cp -> cp.partNumber() == partNum).findFirst().orElse(null);
                if (p2 == null) {
                    return;
                }
                allParts.add(p2);
            }
            this.s3.completeMultipartUpload((CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(this.bucket).key(key).uploadId(session.uploadId()).multipartUpload((CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(allParts).build()).build()).join();
            if (this.listener != null) {
                try {
                    this.listener.uploadFileFinished(file);
                }
                catch (Throwable pn2) {}
            }
        }
        catch (Throwable t) {
            if (t instanceof SyncException) {
                SyncException doe = (SyncException)t;
                throw doe;
            }
            throw new SyncException("Multipart upload failed for key " + key + " with error: " + t.getMessage(), t);
        }
    }

    private boolean objectExists(String bucket, String key) throws SyncException {
        try {
            this.s3.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket).key(key).build()).get();
            return true;
        }
        catch (ExecutionException ee) {
            S3Exception s3e;
            int code;
            Throwable cause = ee.getCause();
            if (cause instanceof NoSuchKeyException) {
                return false;
            }
            if (cause instanceof S3Exception && ((code = (s3e = (S3Exception)cause).statusCode()) == 404 || code == 403)) {
                return false;
            }
            throw new SyncException("HeadObject failed for key " + key, cause);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new SyncException("Interrupted during HeadObject for key " + key, ie);
        }
    }

    private UploadSession resolveOrCreateUploadId(String bucket, String key) throws SyncException {
        try {
            ListMultipartUploadsResponse listResp = (ListMultipartUploadsResponse)this.s3.listMultipartUploads((ListMultipartUploadsRequest)ListMultipartUploadsRequest.builder().bucket(bucket).prefix(key).build()).get();
            for (MultipartUpload u : listResp.uploads()) {
                if (!key.equals(u.key())) continue;
                return new UploadSession(u.uploadId(), false);
            }
            CreateMultipartUploadResponse createResp = (CreateMultipartUploadResponse)this.s3.createMultipartUpload((CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(bucket).key(key).checksumAlgorithm(ChecksumAlgorithm.SHA256).build()).get();
            return new UploadSession(createResp.uploadId(), true);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new SyncException("Interrupted resolving uploadId", ie);
        }
        catch (ExecutionException ee) {
            throw new SyncException("Failed resolving uploadId", ee.getCause());
        }
    }

    private List<Part> listAllParts(String bucket, String key, String uploadId) throws SyncException {
        try {
            boolean truncated;
            ArrayList<Part> parts = new ArrayList<Part>();
            Integer partNumberMarker = null;
            do {
                ListPartsRequest.Builder b = ListPartsRequest.builder().bucket(bucket).key(key).uploadId(uploadId);
                if (partNumberMarker != null) {
                    b = b.partNumberMarker(partNumberMarker);
                }
                ListPartsResponse resp = (ListPartsResponse)this.s3.listParts((ListPartsRequest)b.build()).get();
                parts.addAll(resp.parts());
                truncated = Boolean.TRUE.equals(resp.isTruncated());
                partNumberMarker = resp.nextPartNumberMarker();
            } while (truncated);
            return parts;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new SyncException("Interrupted listing parts", ie);
        }
        catch (ExecutionException ee) {
            throw new SyncException("Failed listing parts", ee.getCause());
        }
    }

    @Override
    public void close() {
    }

    private static String computeSha256Base64(Path file, long start, long size) {
        String string;
        block9: {
            FileChannel ch = FileChannel.open(file, StandardOpenOption.READ);
            try {
                int n;
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                ch.position(start);
                ByteBuffer buf = ByteBuffer.allocate(262144);
                for (long remaining = size; remaining > 0L; remaining -= (long)n) {
                    int toRead = (int)Math.min((long)buf.capacity(), remaining);
                    buf.clear();
                    buf.limit(toRead);
                    n = ch.read(buf);
                    if (n < 0) break;
                    buf.flip();
                    md.update(buf);
                }
                string = Base64.getEncoder().encodeToString(md.digest());
                if (ch == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ch != null) {
                        try {
                            ch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed computing SHA-256 for slice", e);
                }
            }
            ch.close();
        }
        return string;
    }

    private record UploadSession(String uploadId, boolean createdWithSha256) {
    }

    private static final class FileSlicePublisher
    implements Publisher<ByteBuffer> {
        private final Path file;
        private final long start;
        private final long size;
        private final int chunkSize;

        FileSlicePublisher(Path file, long start, long size, int chunkSize) {
            this.file = Objects.requireNonNull(file, "file");
            this.start = start;
            this.size = size;
            this.chunkSize = Math.max(1, chunkSize);
        }

        public void subscribe(Subscriber<? super ByteBuffer> sub) {
            Objects.requireNonNull(sub, "subscriber");
            sub.onSubscribe((Subscription)new FileSliceSubscription(sub, this.file, this.start, this.size, this.chunkSize));
        }

        private static final class FileSliceSubscription
        implements Subscription {
            private final Subscriber<? super ByteBuffer> sub;
            private final Path file;
            private final long endExclusive;
            private final int chunkSize;
            private FileChannel channel;
            private long position;
            private volatile boolean done;
            private volatile boolean cancelled;
            private volatile long requested;
            private static final AtomicLongFieldUpdater<FileSliceSubscription> REQUESTED_UPDATER = AtomicLongFieldUpdater.newUpdater(FileSliceSubscription.class, "requested");

            FileSliceSubscription(Subscriber<? super ByteBuffer> sub, Path file, long start, long size, int chunkSize) {
                this.sub = sub;
                this.file = file;
                this.position = start;
                this.endExclusive = start + size;
                this.chunkSize = chunkSize;
            }

            public void request(long n) {
                if (this.cancelled || this.done) {
                    return;
                }
                if (n <= 0L) {
                    this.onError(new IllegalArgumentException("non-positive request"));
                    return;
                }
                this.addRequest(n);
                this.drain();
            }

            public void cancel() {
                this.cancelled = true;
                this.closeQuietly();
            }

            private void drain() {
                if (this.cancelled || this.done) {
                    return;
                }
                try {
                    if (this.channel == null) {
                        this.channel = FileChannel.open(this.file, StandardOpenOption.READ);
                        this.channel.position(this.position);
                    }
                    while (this.requested > 0L && this.position < this.endExclusive && !this.cancelled) {
                        int toRead = (int)Math.min((long)this.chunkSize, this.endExclusive - this.position);
                        ByteBuffer buf = ByteBuffer.allocate(toRead);
                        int read = this.channel.read(buf);
                        if (read < 0) {
                            this.done = true;
                            this.closeQuietly();
                            this.sub.onComplete();
                            return;
                        }
                        buf.flip();
                        this.position += (long)read;
                        this.produced(1L);
                        this.sub.onNext((Object)buf);
                    }
                    if (this.position >= this.endExclusive && !this.done && !this.cancelled) {
                        this.done = true;
                        this.closeQuietly();
                        this.sub.onComplete();
                    }
                }
                catch (Throwable t) {
                    this.onError(t);
                }
            }

            private void onError(Throwable t) {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.closeQuietly();
                this.sub.onError(t);
            }

            private void addRequest(long n) {
                long next;
                long prev;
                do {
                    if ((next = (prev = this.requested) + n) >= 0L) continue;
                    next = Long.MAX_VALUE;
                } while (!REQUESTED_UPDATER.compareAndSet(this, prev, next));
            }

            private void produced(long n) {
                long next;
                long prev;
                while (!REQUESTED_UPDATER.compareAndSet(this, prev = this.requested, next = prev - n)) {
                }
            }

            private void closeQuietly() {
                if (this.channel != null) {
                    try {
                        this.channel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    record ExistingPart(String eTag, String checksumSHA256) {
    }
}

