/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.code.content;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import org.apache.commons.io.filefilter.IOFileFilter;

public class ExcludeGitDirectoryFileFilter
implements FileFilter,
IOFileFilter {
    private final Path rootDir;

    public ExcludeGitDirectoryFileFilter(Path rootDir) {
        this.rootDir = rootDir;
    }

    @Override
    public boolean accept(File targetPath) {
        Path relativePath = this.rootDir.relativize(targetPath.toPath());
        return ExcludeGitDirectoryFileFilter.notPartOfGit(relativePath);
    }

    public boolean accept(File directory, String targetPath) {
        return this.accept(directory.toPath().resolve(targetPath).toFile());
    }

    private static boolean notPartOfGit(Path relativePath) {
        return !relativePath.startsWith(".git" + File.separator);
    }
}

