/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.code.metrics;

import io.accelerate.tracking.code.metrics.SourceCodeRecordingListener;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceCodeRecordingMetricsCollector
implements SourceCodeRecordingListener {
    private static final Logger log = LoggerFactory.getLogger(SourceCodeRecordingMetricsCollector.class);
    private boolean isCurrentlyRecording;
    private int totalSnapshots = 0;
    private long timestampBeforeProcessingNanos = 0L;
    private long lastSnapshotProcessingTimeNano;

    @Override
    public void notifyRecordingStart(Path destinationPath) {
        this.isCurrentlyRecording = true;
        log.info("Start recording to \"" + String.valueOf(destinationPath.getFileName()) + "\"");
    }

    @Override
    public void notifySnapshotStart(long timestamp, TimeUnit unit) {
        log.debug("Source Code snap !");
        this.timestampBeforeProcessingNanos = unit.toNanos(timestamp);
    }

    @Override
    public void notifySnapshotEnd(long timestamp, TimeUnit unit) {
        this.lastSnapshotProcessingTimeNano = unit.toNanos(timestamp) - this.timestampBeforeProcessingNanos;
        log.debug("lastSnapshotProcessingTimeNano: {}", (Object)this.lastSnapshotProcessingTimeNano);
        ++this.totalSnapshots;
    }

    @Override
    public void notifyRecordingEnd() {
        this.isCurrentlyRecording = false;
        log.info("Recording stopped");
    }

    public boolean isCurrentlyRecording() {
        return this.isCurrentlyRecording;
    }

    public int getTotalSnapshots() {
        return this.totalSnapshots;
    }

    public long getLastSnapshotProcessingTimeNano() {
        return this.lastSnapshotProcessingTimeNano;
    }
}

