/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.code.snapshot;

import io.accelerate.tracking.code.content.ExcludeGitDirectoryFileFilter;
import io.accelerate.tracking.code.content.SourceCodeProvider;
import io.accelerate.tracking.code.snapshot.EmptySnapshot;
import io.accelerate.tracking.code.snapshot.KeySnapshot;
import io.accelerate.tracking.code.snapshot.PatchSnapshot;
import io.accelerate.tracking.code.snapshot.Snapshot;
import io.accelerate.tracking.code.snapshot.SnapshotRecorderException;
import io.accelerate.tracking.code.snapshot.SnapshotTypeHint;
import io.accelerate.tracking.code.snapshot.helpers.FileHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;

public class SnapshotRecorder
implements AutoCloseable {
    protected final SourceCodeProvider sourceCodeProvider;
    private Git git;
    private Path gitDirectory;
    private int counter = 0;
    private final int keySnapshotPacing;

    public SnapshotRecorder(SourceCodeProvider sourceCodeProvider, int keySnapshotPacing) {
        this.sourceCodeProvider = sourceCodeProvider;
        this.keySnapshotPacing = keySnapshotPacing;
    }

    public void init() throws SnapshotRecorderException {
        this.initGitDirectory();
    }

    private void initGitDirectory() throws SnapshotRecorderException {
        try {
            File sysTmpDir = FileUtils.getTempDirectory();
            this.gitDirectory = Files.createTempDirectory(sysTmpDir.toPath(), this.getClass().getSimpleName(), new FileAttribute[0]);
            this.git = Git.init().setDirectory(this.gitDirectory.toFile()).call();
            this.commitAllChanges();
        }
        catch (IOException | GitAPIException ex) {
            throw new SnapshotRecorderException(ex);
        }
    }

    public Git getGit() {
        return this.git;
    }

    Path getGitDirectory() {
        return this.gitDirectory;
    }

    SnapshotTypeHint syncToGitDirectory() throws IOException {
        this.cleanGitDirectory();
        SnapshotTypeHint snapshotTypeHint = this.sourceCodeProvider.retrieveAndSaveTo(this.gitDirectory);
        FileHelper.deleteEmptyFiles(this.gitDirectory);
        return snapshotTypeHint;
    }

    private void cleanGitDirectory() {
        ExcludeGitDirectoryFileFilter filter = new ExcludeGitDirectoryFileFilter(this.gitDirectory);
        FileUtils.listFiles((File)this.gitDirectory.toFile(), (IOFileFilter)filter, (IOFileFilter)TrueFileFilter.INSTANCE).forEach(File::delete);
    }

    void commitAllChanges() {
        try {
            String message = new Date().toString();
            this.git.add().addFilepattern(".").call();
            this.git.commit().setMessage(message).setAll(true).call();
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    public Snapshot takeSnapshot() throws IOException {
        SnapshotTypeHint snapshotTypeHint = this.syncToGitDirectory();
        this.commitAllChanges();
        Snapshot snapshot = this.decideOnSnapshotType(snapshotTypeHint) == SnapshotTypeHint.PATCH ? this.takePatchSnapshot() : this.takeKeySnapshot();
        return snapshot;
    }

    private SnapshotTypeHint decideOnSnapshotType(SnapshotTypeHint hintFromProvider) {
        SnapshotTypeHint snapshotTypeHint = hintFromProvider;
        if (hintFromProvider == SnapshotTypeHint.ANY) {
            snapshotTypeHint = this.counter % this.keySnapshotPacing == 0 ? SnapshotTypeHint.KEY : SnapshotTypeHint.PATCH;
        }
        ++this.counter;
        return snapshotTypeHint;
    }

    private KeySnapshot takeKeySnapshot() {
        return KeySnapshot.takeSnapshotFromGit(this.git);
    }

    private PatchSnapshot takePatchSnapshot() {
        return PatchSnapshot.takeSnapshotFromGit(this.git);
    }

    public EmptySnapshot takeEmptySnapshot() {
        return EmptySnapshot.takeSnapshotFromGit(this.git);
    }

    @Override
    public void close() {
        this.git.close();
        this.gitDirectory.toFile().deleteOnExit();
    }
}

