/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.code.snapshot.file;

import io.accelerate.tracking.code.snapshot.helpers.ByteHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class Header {
    public static int SIZE = 14;
    public static final byte[] MAGIC_BYTES = new byte[]{83, 82, 67, 83, 84, 77};
    private long timestamp;
    private byte[] magicBytes = MAGIC_BYTES;

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public byte[] getMagicBytes() {
        return this.magicBytes;
    }

    public void setMagicBytes(byte[] magicBytes) {
        this.magicBytes = magicBytes;
    }

    public boolean isValid() {
        return Arrays.equals(this.getMagicBytes(), MAGIC_BYTES);
    }

    public byte[] asBytes() {
        byte[] byArray;
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        try {
            byteArray.write(this.getMagicBytes());
            byteArray.write(ByteHelper.littleEndianLongToByteArray(this.getTimestamp(), 8));
            byArray = byteArray.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArray.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return new byte[0];
            }
        }
        byteArray.close();
        return byArray;
    }
}

