/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.code.snapshot.file;

import io.accelerate.tracking.code.snapshot.EmptySnapshot;
import io.accelerate.tracking.code.snapshot.KeySnapshot;
import io.accelerate.tracking.code.snapshot.PatchSnapshot;
import io.accelerate.tracking.code.snapshot.Snapshot;
import io.accelerate.tracking.code.snapshot.SnapshotType;
import io.accelerate.tracking.code.snapshot.helpers.ByteHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class Segment {
    static final int SIZE_ADDRESS = 14;
    static final int LONG_SIZE = 8;
    static final int TAG_SIZE = 64;
    static final int CHECKSUM_SIZE = 20;
    public static final int HEADER_SIZE = 106;
    private byte[] data;
    private byte[] checksum;
    private String tag;
    private long size;
    private SnapshotType type;
    private long timestampSec;
    private long address;

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    void generateFromData() {
        this.setSize(this.data.length);
        this.setChecksum(this.generateChecksum());
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    void setChecksum(byte[] checksum) {
        this.checksum = checksum;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public SnapshotType getType() {
        return this.type;
    }

    public void setType(SnapshotType type) {
        this.type = type;
    }

    public long getTimestampSec() {
        return this.timestampSec;
    }

    void setTimestampSec(long timestampSec) {
        this.timestampSec = timestampSec;
    }

    public long getAddress() {
        return this.address;
    }

    public void setAddress(long address) {
        this.address = address;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    boolean hasTag() {
        return this.tag != null && this.tag.trim().length() > 0;
    }

    private byte[] generateChecksum() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return md.digest(this.getData());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isChecksumMismatch() {
        byte[] checksumChallenge = this.generateChecksum();
        return !Arrays.equals(checksumChallenge, this.getChecksum());
    }

    public byte[] asBytes() {
        byte[] byArray;
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        try {
            byteArray.write(this.getHeaderAsBytes());
            byteArray.write(this.getData());
            byArray = byteArray.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArray.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return new byte[0];
            }
        }
        byteArray.close();
        return byArray;
    }

    private byte[] getHeaderAsBytes() {
        byte[] byArray;
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream(106);
        try {
            byteArray.write(this.type.getMagicBytes());
            byteArray.write(ByteHelper.littleEndianLongToByteArray(this.getTimestampSec(), 8));
            byteArray.write(ByteHelper.littleEndianLongToByteArray(this.getSize(), 8));
            byteArray.write(this.getTagAsByte());
            byteArray.write(this.getChecksum());
            byArray = byteArray.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArray.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return new byte[0];
            }
        }
        byteArray.close();
        return byArray;
    }

    private byte[] getTagAsByte() {
        String tagToSave = this.getTag();
        if (tagToSave == null) {
            tagToSave = "";
        }
        byte[] src = tagToSave.getBytes(Charset.defaultCharset());
        return Arrays.copyOf(src, 64);
    }

    public Snapshot getSnapshot() {
        switch (this.getType()) {
            case KEY: {
                return KeySnapshot.createSnapshotFromBytes(this.getData());
            }
            case PATCH: {
                return PatchSnapshot.createSnapshotFromBytes(this.getData());
            }
            case EMPTY: {
                return EmptySnapshot.createSnapshotFromBytes(this.getData());
            }
        }
        throw new RuntimeException("Cannot recognize type");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Segment)) {
            return false;
        }
        Segment snapshot = (Segment)obj;
        return this.getType() == snapshot.getType() && this.getTimestampSec() == snapshot.getTimestampSec() && Arrays.equals(this.getChecksum(), snapshot.getChecksum()) && Arrays.equals(this.getData(), snapshot.getData());
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Arrays.hashCode(this.data);
        hash = 67 * hash + Arrays.hashCode(this.checksum);
        hash = 67 * hash + this.type.hashCode();
        hash = 67 * hash + (int)(this.timestampSec ^ this.timestampSec >>> 32);
        return hash;
    }
}

