/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.code.snapshot.file;

import io.accelerate.tracking.code.content.SourceCodeProvider;
import io.accelerate.tracking.code.snapshot.Snapshot;
import io.accelerate.tracking.code.snapshot.SnapshotRecorder;
import io.accelerate.tracking.code.snapshot.SnapshotRecorderException;
import io.accelerate.tracking.code.snapshot.file.Header;
import io.accelerate.tracking.code.snapshot.file.Segment;
import io.accelerate.tracking.code.snapshot.file.TagManager;
import io.accelerate.tracking.code.time.TimeSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;

public final class Writer
implements AutoCloseable {
    private final File outputFile;
    private final TimeSource timeSource;
    private final long recordedTimestamp;
    private final FileOutputStream outputStream;
    private final SnapshotRecorder recorder;
    private final TagManager tagManager;

    public Writer(Path outputPath, SourceCodeProvider sourceCodeProvider, TimeSource timeSource, long recordedTimestamp, int keySnapshotPacing, boolean append) throws IOException, SnapshotRecorderException {
        this.outputFile = outputPath.toFile();
        this.timeSource = timeSource;
        this.recordedTimestamp = recordedTimestamp;
        this.outputStream = new FileOutputStream(this.outputFile, append);
        this.recorder = new SnapshotRecorder(sourceCodeProvider, keySnapshotPacing);
        this.recorder.init();
        if (this.outputFile.length() == 0L) {
            this.writeHeader();
        }
        this.tagManager = new TagManager();
    }

    private void writeHeader() throws SnapshotRecorderException {
        try {
            Header header = new Header();
            header.setTimestamp(this.recordedTimestamp);
            byte[] data = header.asBytes();
            IOUtils.write((byte[])data, (OutputStream)this.outputStream);
        }
        catch (IOException ex) {
            throw new SnapshotRecorderException(ex);
        }
    }

    public Snapshot takeSnapshot() throws SnapshotRecorderException {
        try {
            return this.recorder.takeSnapshot();
        }
        catch (IOException e) {
            throw new SnapshotRecorderException(e);
        }
    }

    public void writeSnapshotWithTags(Snapshot snapshot, List<String> tags) throws SnapshotRecorderException {
        List<String> tagsToWrite = tags.size() > 0 ? tags : Collections.singletonList("");
        Snapshot currentSnapshot = snapshot;
        for (String tag : tagsToWrite) {
            try {
                Segment segment = this.createSegmentFromSnapshot(currentSnapshot);
                if (TagManager.isTag(tag)) {
                    segment.setTag(this.tagManager.asValidTag(tag));
                }
                IOUtils.write((byte[])segment.asBytes(), (OutputStream)this.outputStream);
            }
            catch (IOException ex) {
                throw new SnapshotRecorderException(ex);
            }
            currentSnapshot = this.recorder.takeEmptySnapshot();
        }
    }

    private Segment createSegmentFromSnapshot(Snapshot snapshot) {
        long timestampSec = TimeUnit.NANOSECONDS.toSeconds(this.timeSource.currentTimeNano());
        byte[] data = snapshot.getData();
        Segment segment = new Segment();
        segment.setType(snapshot.getType());
        segment.setTimestampSec(timestampSec);
        segment.setData(data);
        segment.generateFromData();
        return segment;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((OutputStream)this.outputStream);
    }
}

