/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.code.snapshot.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import jgit.hack.ApplyCommandFixed;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.archive.ArchiveFormats;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.ignore.FastIgnoreRule;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHelper {
    private static final Logger log = LoggerFactory.getLogger(GitHelper.class);
    private static String ARCHIVE_FORMAT_ZIP = "zip";
    private static final String FALLBACK_DIFF_ALGORITHM = DiffAlgorithm.SupportedAlgorithm.HISTOGRAM.toString().toLowerCase();

    public static boolean isGitDirectory(Path path) {
        File directory = path.toFile();
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        builder.addCeilingDirectory(directory);
        builder.findGitDir(directory);
        return builder.getGitDir() != null;
    }

    public static void exportArchive(Git git, OutputStream outputStream) throws GitAPIException, IOException {
        ArchiveFormats.registerAll();
        git.archive().setTree(git.getRepository().resolve("master")).setFormat(ARCHIVE_FORMAT_ZIP).setOutputStream(outputStream).call();
        ArchiveFormats.unregisterAll();
    }

    public static void exportDiff(Git git, OutputStream outputStream) throws Exception {
        Repository repository = git.getRepository();
        GitHelper.fixDiffAlgorithmIfNotSupported(repository);
        ObjectId oldHead = repository.resolve("HEAD^^{tree}");
        ObjectId head = repository.resolve("HEAD^{tree}");
        if (oldHead == null) {
            return;
        }
        try (ObjectReader reader = repository.newObjectReader();){
            CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
            oldTreeIter.reset(reader, (AnyObjectId)oldHead);
            CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
            newTreeIter.reset(reader, (AnyObjectId)head);
            git.diff().setNewTree((AbstractTreeIterator)newTreeIter).setOldTree((AbstractTreeIterator)oldTreeIter).setOutputStream(outputStream).call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fixDiffAlgorithmIfNotSupported(Repository repository) throws IOException, ConfigInvalidException {
        repository.getConfig().load();
        String configuredDiffAlgorithm = repository.getConfig().getString("diff", null, "algorithm");
        DiffAlgorithm.SupportedAlgorithm supportedAlgorithm = null;
        try {
            if (configuredDiffAlgorithm != null) {
                supportedAlgorithm = DiffAlgorithm.SupportedAlgorithm.valueOf((String)configuredDiffAlgorithm.toUpperCase());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            if (supportedAlgorithm == null) {
                repository.getConfig().setString("diff", null, "algorithm", FALLBACK_DIFF_ALGORITHM);
                log.debug("Warning: local or global git config file is set to use an unsupported diff algorithm: {}", (Object)configuredDiffAlgorithm);
                log.debug("It has been overridden to use the 'histogram' diff algorithm.");
            }
        }
    }

    public static void applyDiff(Git git, InputStream inputStream) throws Exception {
        new ApplyCommandFixed(git.getRepository()).setPatch(inputStream).call();
    }

    public static void addAndCommit(Git git) throws GitAPIException {
        git.add().addFilepattern(".").call();
        git.commit().setAll(true).setMessage("Commit").call();
    }

    public static int getCommitCount(Git git) throws GitAPIException {
        Iterable commits = git.log().call();
        int count = 0;
        for (Object ignored : commits) {
            ++count;
        }
        return count;
    }

    public static void tag(Git git, String name) throws GitAPIException {
        git.tag().setName(name).call();
    }

    public static List<String> getTags(Git git) throws GitAPIException {
        return git.tagList().call().stream().map(Ref::getName).map(s -> s.replaceAll("refs/tags/", "")).collect(Collectors.toList());
    }

    public static List<FastIgnoreRule> getIgnoredFiles(Path sourceFolderPath) throws IOException {
        ArrayList<FastIgnoreRule> results = new ArrayList<FastIgnoreRule>();
        String pathToGitIgnore = sourceFolderPath.toString() + File.separator + ".gitignore";
        if (!new File(pathToGitIgnore).exists()) {
            return results;
        }
        IgnoreNode ignoreNode = new IgnoreNode();
        FileInputStream gitignoreFileStream = new FileInputStream(new File(pathToGitIgnore));
        ignoreNode.parse((InputStream)gitignoreFileStream);
        return ignoreNode.getRules();
    }
}

