/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.code.test.support.content;

import io.accelerate.tracking.code.content.SourceCodeProvider;
import io.accelerate.tracking.code.snapshot.SnapshotTypeHint;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.io.FileUtils;

public class RandomSourceCodeProvider
implements SourceCodeProvider {
    @Override
    public SnapshotTypeHint retrieveAndSaveTo(Path destinationFolder) throws IOException {
        this.createRandomFile(destinationFolder);
        return SnapshotTypeHint.ANY;
    }

    private void createRandomFile(Path directoryPath) throws IOException {
        String name = UUID.randomUUID().toString();
        File newFile = directoryPath.resolve(name).toFile();
        boolean newFileResult = newFile.createNewFile();
        if (!newFileResult) {
            throw new IOException("File already exists");
        }
        FileUtils.writeStringToFile((File)newFile, (String)name, (Charset)StandardCharsets.US_ASCII);
        byte[] random = new byte[1000];
        new Random().nextBytes(random);
        FileUtils.writeByteArrayToFile((File)newFile, (byte[])random, (boolean)true);
    }
}

