/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.code.test.support.recording;

import io.accelerate.tracking.code.record.SourceCodeRecorder;
import io.accelerate.tracking.code.record.SourceCodeRecorderException;
import io.accelerate.tracking.code.test.support.content.ChangeableWrappedSourceCodeProvider;
import io.accelerate.tracking.code.test.support.content.EmptySourceCodeProvider;
import io.accelerate.tracking.code.test.support.recording.TestRecordingFrame;
import io.accelerate.tracking.code.test.support.time.FakeTimeSource;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class TestSourceCodeRecorder {
    private int currentFrameIndex;
    private final List<TestRecordingFrame> recordingFrames;
    private final SourceCodeRecorder sourceCodeRecorder;
    private final ChangeableWrappedSourceCodeProvider changeableWrappedSourceCodeProvider;

    public TestSourceCodeRecorder(Path outputFilePath, List<TestRecordingFrame> recordingFrames) {
        this.recordingFrames = recordingFrames;
        FakeTimeSource fakeTimeSource = new FakeTimeSource();
        this.changeableWrappedSourceCodeProvider = new ChangeableWrappedSourceCodeProvider();
        this.sourceCodeRecorder = new SourceCodeRecorder.Builder(this.changeableWrappedSourceCodeProvider, outputFilePath).withTimeSource(fakeTimeSource).withSnapshotEvery(1, TimeUnit.SECONDS).withKeySnapshotSpacing(3).build();
        this.seedRecorderWithFrame(this.getAndAdvance(recordingFrames));
        fakeTimeSource.addWakeUpAtListener(() -> this.seedRecorderWithFrame(this.getAndAdvance(recordingFrames)));
    }

    private TestRecordingFrame getAndAdvance(List<TestRecordingFrame> recordingFrames) {
        if (this.currentFrameIndex < recordingFrames.size()) {
            TestRecordingFrame testRecordingFrame = recordingFrames.get(this.currentFrameIndex);
            ++this.currentFrameIndex;
            return testRecordingFrame;
        }
        return new TestRecordingFrame(new EmptySourceCodeProvider());
    }

    private void seedRecorderWithFrame(TestRecordingFrame currentFrame) {
        this.changeableWrappedSourceCodeProvider.setSourceCodeProvider(currentFrame.getSourceCodeProvider());
        for (String tag : currentFrame.getTags()) {
            this.sourceCodeRecorder.tagCurrentState(tag);
        }
    }

    public void start() throws SourceCodeRecorderException {
        this.sourceCodeRecorder.start(Duration.of(this.recordingFrames.size(), ChronoUnit.SECONDS));
    }

    public void close() {
        this.sourceCodeRecorder.close();
        this.currentFrameIndex = 0;
    }
}

