/*
 * Decompiled with CFR 0.152.
 */
package io.accelerate.tracking.code.test.support.time;

import io.accelerate.tracking.code.test.support.time.WakeUpListener;
import io.accelerate.tracking.code.time.TimeSource;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class FakeTimeSource
implements TimeSource {
    private long currentTimeNano = 0L;
    private long incrementNanos = 1L;
    private final ArrayList<WakeUpListener> wakeUpListeners = new ArrayList();

    @Override
    public long currentTimeNano() {
        this.currentTimeNano += this.incrementNanos;
        return this.currentTimeNano;
    }

    @Override
    public void wakeUpAt(long timestamp, TimeUnit timeUnit) {
        this.currentTimeNano = timeUnit.toNanos(timestamp);
        this.notifyWakeUpAtListeners();
    }

    @Override
    public void wakeUpNow() {
        this.currentTimeNano += this.incrementNanos;
    }

    public void addWakeUpAtListener(WakeUpListener wakeUpListener) {
        this.wakeUpListeners.add(wakeUpListener);
    }

    private void notifyWakeUpAtListeners() {
        this.wakeUpListeners.forEach(WakeUpListener::wakeUpInvoked);
    }
}

