/*
 * Decompiled with CFR 0.152.
 */
package jgit.hack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.Patch;

public class FilterFileRenames {
    public List<FileHeader> apply(Patch p) {
        List files = p.getFiles();
        HashMap<String, Set> operationsPerFile = new HashMap<String, Set>();
        for (FileHeader fh : files) {
            String targetPath = FilterFileRenames.getTargetPath(fh);
            DiffEntry.ChangeType type = fh.getChangeType();
            Set setForFile = operationsPerFile.getOrDefault(targetPath, new HashSet());
            setForFile.add(type);
            operationsPerFile.put(targetPath, setForFile);
        }
        Set renames = operationsPerFile.entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(DiffEntry.ChangeType.ADD) && ((Set)entry.getValue()).contains(DiffEntry.ChangeType.DELETE)).map(Map.Entry::getKey).collect(Collectors.toSet());
        ArrayList<FileHeader> filteredFiles = new ArrayList<FileHeader>();
        for (FileHeader fh : files) {
            String targetPath = FilterFileRenames.getTargetPath(fh);
            DiffEntry.ChangeType type = fh.getChangeType();
            if (renames.contains(targetPath) && type == DiffEntry.ChangeType.DELETE) continue;
            filteredFiles.add(fh);
        }
        return filteredFiles;
    }

    private static String getTargetPath(FileHeader fh) {
        DiffEntry.ChangeType type = fh.getChangeType();
        String targetPath = type == DiffEntry.ChangeType.ADD ? fh.getNewPath() : fh.getOldPath();
        return targetPath.toLowerCase();
    }
}

