/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JPackage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public class CaseSensitiveFileCodeWriter
extends CodeWriter {
    private final File target;
    private final boolean readOnly;
    private final Set<File> readonlyFiles = new HashSet<File>();
    private boolean generateLowercasePath;

    public CaseSensitiveFileCodeWriter(File target, boolean readOnly, boolean generateLowercasePath) throws IOException {
        this.target = target;
        this.readOnly = readOnly;
        if (!target.exists() || !target.isDirectory()) {
            throw new IOException(target + ": non-existent directory");
        }
        this.generateLowercasePath = generateLowercasePath;
    }

    public OutputStream openBinary(JPackage pkg, String fileName) throws IOException {
        return new FileOutputStream(this.getFile(pkg, fileName));
    }

    protected File getFile(JPackage pkg, String fileName) throws IOException {
        File fn;
        File dir = pkg.isUnnamed() ? this.target : new File(this.target, this.toDirName(pkg));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((fn = new File(dir, fileName)).exists() && !fn.delete()) {
            throw new IOException(fn + ": Can't delete previous version");
        }
        if (this.readOnly) {
            this.readonlyFiles.add(fn);
        }
        return fn;
    }

    public void close() throws IOException {
        for (File f : this.readonlyFiles) {
            f.setReadOnly();
        }
    }

    private String toDirName(JPackage pkg) {
        String packageName = this.generateLowercasePath ? pkg.name().toLowerCase() : pkg.name();
        return packageName.replace('.', File.separatorChar);
    }
}

