/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaParserFactory;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.resolver.AbstractMultiFormatDataSchemaResolver;
import com.linkedin.data.schema.resolver.FileDataSchemaLocation;
import com.linkedin.data.schema.resolver.InJarFileDataSchemaLocation;
import com.linkedin.data.schema.resolver.MultiFormatDataSchemaResolver;
import com.linkedin.data.schema.resolver.SchemaDirectory;
import com.linkedin.data.schema.resolver.SchemaDirectoryName;
import com.linkedin.pegasus.generator.FileFormatDataSchemaParser;
import com.linkedin.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class DataSchemaParser {
    private final String _resolverPath;
    private final Map<String, FileFormatDataSchemaParser> _parserByFileExtension = new HashMap<String, FileFormatDataSchemaParser>();
    private final AbstractMultiFormatDataSchemaResolver _resolver;

    @Deprecated
    public DataSchemaParser(String resolverPath) {
        this(resolverPath, AbstractMultiFormatDataSchemaResolver.BUILTIN_FORMAT_PARSER_FACTORIES, Collections.singletonList(SchemaDirectoryName.PEGASUS), Collections.singletonList(SchemaDirectoryName.PEGASUS));
    }

    @Deprecated
    public DataSchemaParser(String resolverPath, List<DataSchemaParserFactory> parserFactoriesForFormats) {
        this(resolverPath, parserFactoriesForFormats, Collections.singletonList(SchemaDirectoryName.PEGASUS), Collections.singletonList(SchemaDirectoryName.PEGASUS));
    }

    @Deprecated
    public DataSchemaParser(String resolverPath, AbstractMultiFormatDataSchemaResolver resolver) {
        this._resolverPath = resolverPath;
        this._resolver = resolver;
        this.init(resolver, MultiFormatDataSchemaResolver.BUILTIN_FORMAT_PARSER_FACTORIES, resolver.getSchemaDirectories());
    }

    private DataSchemaParser(String resolverPath, List<DataSchemaParserFactory> parserFactoriesForFormats, List<SchemaDirectory> sourceDirectories, List<SchemaDirectory> resolverDirectories) {
        this._resolverPath = resolverPath;
        MultiFormatDataSchemaResolver resolver = new MultiFormatDataSchemaResolver(resolverPath, parserFactoriesForFormats, resolverDirectories);
        this._resolver = resolver;
        this.init((AbstractMultiFormatDataSchemaResolver)resolver, MultiFormatDataSchemaResolver.BUILTIN_FORMAT_PARSER_FACTORIES, sourceDirectories);
    }

    public String getResolverPath() {
        return this._resolverPath;
    }

    public DataSchemaResolver getSchemaResolver() {
        return this._resolver;
    }

    public ParseResult parseSources(String[] rawSources) throws IOException {
        Set<String> fileExtensions = this._parserByFileExtension.keySet();
        HashMap byExtension = new HashMap(fileExtensions.size());
        for (String string : fileExtensions) {
            byExtension.put(string, new ArrayList());
        }
        Object[] sortedSources = Arrays.copyOf(rawSources, rawSources.length);
        Arrays.sort(sortedSources);
        for (Object source : sortedSources) {
            File sourceFile = new File((String)source);
            if (!sourceFile.exists()) continue;
            if (sourceFile.isDirectory()) {
                FileExtensionFilter filter = new FileExtensionFilter(fileExtensions);
                List sourceFilesInDirectory = FileUtil.listFiles((File)sourceFile, (FileFilter)filter);
                for (File f : sourceFilesInDirectory) {
                    String ext = FilenameUtils.getExtension((String)f.getName());
                    List filesForExtension = (List)byExtension.get(ext);
                    if (filesForExtension == null) continue;
                    filesForExtension.add(f.getAbsolutePath());
                }
                continue;
            }
            if (sourceFile.getName().endsWith(".jar")) {
                byExtension.values().forEach(files -> files.add(sourceFile.getAbsolutePath()));
                continue;
            }
            String ext = FilenameUtils.getExtension((String)sourceFile.getName());
            List filesForExtension = (List)byExtension.get(ext);
            if (filesForExtension == null) continue;
            filesForExtension.add(sourceFile.getAbsolutePath());
        }
        ParseResult parseResult = new ParseResult();
        for (Map.Entry entry : byExtension.entrySet()) {
            String ext = (String)entry.getKey();
            List files2 = (List)entry.getValue();
            this._parserByFileExtension.get(ext).parseSources(files2.toArray(new String[files2.size()]), parseResult);
        }
        return parseResult;
    }

    private void init(AbstractMultiFormatDataSchemaResolver resolver, List<DataSchemaParserFactory> parserFactoriesForFormats, List<SchemaDirectory> sourceDirectories) {
        for (DataSchemaParserFactory parserForFormat : parserFactoriesForFormats) {
            FileFormatDataSchemaParser fileFormatParser = new FileFormatDataSchemaParser((DataSchemaResolver)resolver, parserForFormat, sourceDirectories);
            this._parserByFileExtension.put(parserForFormat.getLanguageExtension(), fileFormatParser);
        }
    }

    public static class Builder {
        private final String _resolverPath;
        private List<DataSchemaParserFactory> _parserFactoriesForFormats = AbstractMultiFormatDataSchemaResolver.BUILTIN_FORMAT_PARSER_FACTORIES;
        private List<SchemaDirectory> _sourceDirectories = Collections.singletonList(SchemaDirectoryName.PEGASUS);
        private List<SchemaDirectory> _resolverDirectories = Collections.singletonList(SchemaDirectoryName.PEGASUS);

        public Builder(String resolverPath) {
            this._resolverPath = resolverPath;
        }

        public static Builder newBuilder(String resolverPath) {
            return new Builder(resolverPath);
        }

        public Builder setParserFactoriesForFormats(List<DataSchemaParserFactory> parserFactoriesForFormats) {
            this._parserFactoriesForFormats = parserFactoriesForFormats;
            return this;
        }

        public Builder setSourceDirectories(List<SchemaDirectory> sourceDirectories) {
            this._sourceDirectories = sourceDirectories;
            return this;
        }

        public Builder setResolverDirectories(List<SchemaDirectory> resolverDirectories) {
            this._resolverDirectories = resolverDirectories;
            return this;
        }

        public DataSchemaParser build() {
            return new DataSchemaParser(this._resolverPath, this._parserFactoriesForFormats, this._sourceDirectories, this._resolverDirectories);
        }
    }

    public static class ParseResult {
        private static final String EXTENSION_FILENAME_SUFFIX = "Extensions.pdl";
        private final Map<DataSchema, DataSchemaLocation> _schemaAndLocations = new LinkedHashMap<DataSchema, DataSchemaLocation>();
        private final Set<File> _sourceFiles = new HashSet<File>();
        protected final StringBuilder _messageBuilder = new StringBuilder();

        public Map<DataSchema, DataSchemaLocation> getSchemaAndLocations() {
            return this._schemaAndLocations;
        }

        public Map<DataSchema, DataSchemaLocation> getBaseDataSchemaAndLocations() {
            return this._schemaAndLocations.entrySet().stream().filter(entry -> !ParseResult.isExtensionSchemaLocation(entry)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public Map<DataSchema, DataSchemaLocation> getExtensionDataSchemaAndLocations() {
            return this._schemaAndLocations.entrySet().stream().filter(ParseResult::isExtensionSchemaLocation).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        static boolean isExtensionSchemaLocation(Map.Entry<DataSchema, DataSchemaLocation> entry) {
            DataSchemaLocation dataSchemaLocation = entry.getValue();
            if (dataSchemaLocation instanceof InJarFileDataSchemaLocation) {
                InJarFileDataSchemaLocation inJarFileDataSchemaLocation = (InJarFileDataSchemaLocation)dataSchemaLocation;
                return inJarFileDataSchemaLocation.getPathInJar().startsWith(SchemaDirectoryName.EXTENSIONS.getName());
            }
            if (dataSchemaLocation instanceof FileDataSchemaLocation) {
                FileDataSchemaLocation fileDataSchemaLocation = (FileDataSchemaLocation)dataSchemaLocation;
                return fileDataSchemaLocation.getSourceFile().getName().endsWith(EXTENSION_FILENAME_SUFFIX) && fileDataSchemaLocation.getSourceFile().getParent().indexOf(SchemaDirectoryName.EXTENSIONS.getName()) > 0;
            }
            return false;
        }

        public Set<File> getSourceFiles() {
            return this._sourceFiles;
        }

        public String getMessage() {
            return this._messageBuilder.toString();
        }

        public ParseResult addMessage(String message) {
            this._messageBuilder.append(message);
            return this;
        }
    }

    private static class FileExtensionFilter
    implements FileFilter {
        private final Set<String> extensions;

        public FileExtensionFilter(Set<String> extensions) {
            this.extensions = extensions;
        }

        @Override
        public boolean accept(File file) {
            return this.extensions.contains(FilenameUtils.getExtension((String)file.getName()));
        }
    }
}

