/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.internal.tools.ArgumentFileProcessor;
import com.linkedin.pegasus.generator.CaseSensitiveFileCodeWriter;
import com.linkedin.pegasus.generator.DataSchemaParser;
import com.linkedin.pegasus.generator.DataTemplatePersistentClassChecker;
import com.linkedin.pegasus.generator.JavaCodeUtil;
import com.linkedin.pegasus.generator.JavaDataTemplateGenerator;
import com.linkedin.pegasus.generator.ProjectionMaskApiChecker;
import com.linkedin.pegasus.generator.TemplateSpecGenerator;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import com.linkedin.util.FileUtil;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTemplateGeneratorCmdLineApp {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTemplateGeneratorCmdLineApp.class);
    private static final Options OPTIONS = new Options();

    private static void help() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(120, DataTemplateGeneratorCmdLineApp.class.getSimpleName(), "Command should be followed by one or more source files to process.", OPTIONS, "[sources]+          List of source files or directories to process, specified at the end. Source file list can also be provided as a single arg file, specified as @<arg filename>. The file should list source files/directories one per line.", true);
    }

    public static void main(String[] args) throws IOException {
        try {
            String[] sources;
            GnuParser parser = new GnuParser();
            CommandLine cl = parser.parse(OPTIONS, args);
            if (cl.hasOption('h')) {
                DataTemplateGeneratorCmdLineApp.help();
                System.exit(0);
            }
            boolean generateImported = !Boolean.parseBoolean(cl.getOptionValue('i', "false"));
            boolean generateLowercasePath = !Boolean.parseBoolean(cl.getOptionValue('c', "false"));
            boolean generateFieldMask = !Boolean.parseBoolean(cl.getOptionValue('m', "false"));
            String targetDirectory = cl.getOptionValue('d');
            String defaultPackage = cl.getOptionValue('n');
            String resolverPath = cl.getOptionValue('p');
            if (resolverPath != null && ArgumentFileProcessor.isArgFile((String)resolverPath)) {
                resolverPath = ArgumentFileProcessor.getContentsAsArray((String)resolverPath)[0];
            }
            LOGGER.debug("Resolver Path: " + resolverPath);
            String rootPath = cl.getOptionValue('t');
            String[] resolverSchemaDirectories = null;
            if (cl.hasOption('r')) {
                resolverSchemaDirectories = cl.getOptionValue('r').split(",");
            }
            if ((sources = cl.getArgs()).length == 1 && ArgumentFileProcessor.isArgFile((String)sources[0])) {
                sources = ArgumentFileProcessor.getContentsAsArray((String)sources[0]);
            } else if (sources.length == 0) {
                DataTemplateGeneratorCmdLineApp.help();
                System.exit(0);
            }
            DataTemplateGeneratorCmdLineApp.run(resolverPath, defaultPackage, rootPath, generateImported, targetDirectory, sources, generateLowercasePath, generateFieldMask, resolverSchemaDirectories);
        }
        catch (IOException | ParseException e) {
            LOGGER.error("Encountered error while generating template classes: " + e.getMessage());
            DataTemplateGeneratorCmdLineApp.help();
            System.exit(1);
        }
    }

    private static void run(String resolverPath, String defaultPackage, String rootPath, boolean generateImported, String targetDirectoryPath, String[] sources, boolean generateLowercasePath, boolean generateFieldMask, String[] resolverSchemaDirectories) throws IOException {
        DataSchemaParser.Builder schemaParserBuilder = new DataSchemaParser.Builder(resolverPath);
        if (resolverSchemaDirectories != null) {
            schemaParserBuilder.setResolverDirectories(Arrays.stream(resolverSchemaDirectories).map(directory -> () -> directory).collect(Collectors.toList()));
        }
        DataSchemaParser schemaParser = schemaParserBuilder.build();
        TemplateSpecGenerator specGenerator = new TemplateSpecGenerator(schemaParser.getSchemaResolver());
        JavaDataTemplateGenerator.Config config = new JavaDataTemplateGenerator.Config();
        config.setDefaultPackage(defaultPackage);
        config.setRootPath(rootPath);
        config.setFieldMaskMethods(generateFieldMask);
        for (DataSchema dataSchema : JavaDataTemplateGenerator.PredefinedJavaClasses.keySet()) {
            specGenerator.registerDefinedSchema(dataSchema);
        }
        DataSchemaParser.ParseResult parseResult = schemaParser.parseSources(sources);
        for (Map.Entry<DataSchema, DataSchemaLocation> entry : parseResult.getSchemaAndLocations().entrySet()) {
            specGenerator.generate(entry.getKey(), entry.getValue());
        }
        config.setProjectionMaskApiChecker(new ProjectionMaskApiChecker(specGenerator, parseResult.getSourceFiles(), JavaCodeUtil.classLoaderFromResolverPath(schemaParser.getResolverPath())));
        JavaDataTemplateGenerator javaDataTemplateGenerator = new JavaDataTemplateGenerator(config);
        for (ClassTemplateSpec spec : specGenerator.getGeneratedSpecs()) {
            javaDataTemplateGenerator.generate(spec);
        }
        DataTemplatePersistentClassChecker dataTemplatePersistentClassChecker = new DataTemplatePersistentClassChecker(generateImported, specGenerator, javaDataTemplateGenerator, parseResult.getSourceFiles());
        File targetDirectory = new File(targetDirectoryPath);
        List<File> targetFiles = JavaCodeUtil.targetFiles(targetDirectory, javaDataTemplateGenerator.getCodeModel(), JavaCodeUtil.classLoaderFromResolverPath(schemaParser.getResolverPath()), dataTemplatePersistentClassChecker, generateLowercasePath);
        if (FileUtil.upToDate(parseResult.getSourceFiles(), targetFiles)) {
            LOGGER.info("Target files are up-to-date: " + targetFiles);
        } else {
            LOGGER.info("Generating " + targetFiles.size() + " files");
            LOGGER.debug("Files: " + targetFiles);
            DataTemplateGeneratorCmdLineApp.validateDefinedClassRegistration(javaDataTemplateGenerator.getCodeModel(), javaDataTemplateGenerator.getGeneratedClasses().keySet());
            targetDirectory.mkdirs();
            javaDataTemplateGenerator.getCodeModel().build((CodeWriter)new CaseSensitiveFileCodeWriter(targetDirectory, true, generateLowercasePath));
        }
    }

    private static void validateDefinedClassRegistration(JCodeModel codeModel, Collection<JDefinedClass> classes) {
        Iterator packageIterator = codeModel.packages();
        while (packageIterator.hasNext()) {
            JPackage currentPackage = (JPackage)packageIterator.next();
            Iterator classIterator = currentPackage.classes();
            while (classIterator.hasNext()) {
                JDefinedClass currentClass = (JDefinedClass)classIterator.next();
                if (classes.contains(currentClass)) continue;
                throw new IllegalStateException("Attempting to generate unregistered class: '" + currentClass.fullName() + "'");
            }
        }
    }

    static {
        OPTIONS.addOption("h", "help", false, "Show help.");
        OptionBuilder.withArgName((String)"Skip generating imported schemas");
        OptionBuilder.withLongOpt((String)"skipImportedSchemas");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Specifies whether to skip generating classes for externally resolved schemas.");
        OPTIONS.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withArgName((String)"Generate case sensitive path");
        OptionBuilder.withLongOpt((String)"generateCaseSensitivePath");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Specifies if generated directories should be created using case sensitive path.");
        OPTIONS.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withArgName((String)"Skip generating field mask");
        OptionBuilder.withLongOpt((String)"skipFieldMask");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Specifies if field mask classes should not be generated for templates.");
        OPTIONS.addOption(OptionBuilder.create((char)'m'));
        OptionBuilder.withArgName((String)"Target directory");
        OptionBuilder.withLongOpt((String)"targetDir");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"Target directory in which the classes should be generated.");
        OPTIONS.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withArgName((String)"Resolver Path/ArgFile");
        OptionBuilder.withLongOpt((String)"resolverPath");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Resolver path for loading data schemas. This can also be an arg file with path written per line in the file. Use the syntax @[filename] for this arg when using the arg file.");
        OPTIONS.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withArgName((String)"Root path");
        OptionBuilder.withLongOpt((String)"rootPath");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Root path used to generate the relative location for including in java doc.");
        OPTIONS.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withArgName((String)"Default package");
        OptionBuilder.withLongOpt((String)"defaultPackage");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Default package to use when a PDL schema has no namespace.");
        OPTIONS.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.withArgName((String)"Resolver schema directories");
        OptionBuilder.withLongOpt((String)"resolverSchemaDirectories");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Comma-separated list of schema directory names within the resolver path to use for resolving schemas. Optional, defaults to 'pegasus'.");
        OPTIONS.addOption(OptionBuilder.create((char)'r'));
    }
}

