/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator;

import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.pegasus.generator.JavaCodeUtil;
import com.linkedin.pegasus.generator.JavaDataTemplateGenerator;
import com.linkedin.pegasus.generator.TemplateSpecGenerator;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import com.sun.codemodel.JDefinedClass;
import java.io.File;
import java.util.Set;

public class DataTemplatePersistentClassChecker
implements JavaCodeUtil.PersistentClassChecker {
    private final boolean _generateImported;
    private final TemplateSpecGenerator _specGenerator;
    private final JavaDataTemplateGenerator _dataTemplateGenerator;
    private final Set<File> _sourceFiles;

    public DataTemplatePersistentClassChecker(boolean generateImported, TemplateSpecGenerator specGenerator, JavaDataTemplateGenerator dataTemplateGenerator, Set<File> sourceFiles) {
        this._generateImported = generateImported;
        this._specGenerator = specGenerator;
        this._dataTemplateGenerator = dataTemplateGenerator;
        this._sourceFiles = sourceFiles;
    }

    @Override
    public boolean isPersistent(JDefinedClass clazz) {
        if (this._generateImported) {
            return true;
        }
        ClassTemplateSpec spec = this._dataTemplateGenerator.getGeneratedClasses().get(clazz);
        DataSchemaLocation location = this._specGenerator.getClassLocation(spec);
        return location == null || this._sourceFiles.contains(location.getSourceFile());
    }
}

