/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCodeUtil {
    private static final Logger _log = LoggerFactory.getLogger(JavaCodeUtil.class);

    public static void annotate(JDefinedClass cls, String classType, String location) {
        JavaCodeUtil.annotate(cls, classType, location, null);
    }

    public static void annotate(JDefinedClass cls, String classType, String location, String rootPath) {
        JAnnotationUse generatedAnnotation = cls.annotate(Generated.class);
        generatedAnnotation.param("value", JavaCodeUtil.class.getName());
        String comments = "Rest.li " + classType;
        if (location != null) {
            comments = rootPath == null ? comments + ". Generated from " + location + '.' : comments + ". Generated from " + Paths.get(rootPath, new String[0]).relativize(Paths.get(location, new String[0])) + '.';
        }
        generatedAnnotation.param("comments", comments);
    }

    public static String getGetterName(JCodeModel codeModel, JType type, String capitalizedName) {
        String getterPrefix = type.unboxify() == codeModel.BOOLEAN ? "is" : "get";
        return getterPrefix + capitalizedName;
    }

    public static List<File> targetFiles(File targetDirectory, JCodeModel codeModel, ClassLoader classLoader, PersistentClassChecker checker) {
        return JavaCodeUtil.targetFiles(targetDirectory, codeModel, classLoader, checker, true);
    }

    public static List<File> targetFiles(File targetDirectory, JCodeModel codeModel, ClassLoader classLoader, PersistentClassChecker checker, boolean generateLowercasePath) {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        Iterator packageIterator = codeModel.packages();
        while (packageIterator.hasNext()) {
            Iterator classIterator = ((JPackage)packageIterator.next()).classes();
            while (classIterator.hasNext()) {
                String path;
                boolean classFound;
                JDefinedClass definedClass = (JDefinedClass)classIterator.next();
                try {
                    Class<?> clazz = classLoader.loadClass(definedClass.fullName());
                    classFound = true;
                }
                catch (ClassNotFoundException e) {
                    classFound = false;
                }
                if (classFound) {
                    _log.debug(definedClass.fullName() + " found in resolver path");
                    definedClass.hide();
                    continue;
                }
                if (!checker.isPersistent(definedClass)) {
                    definedClass.hide();
                    continue;
                }
                if (definedClass.outer() != null) continue;
                if (generateLowercasePath) {
                    String fullName = definedClass.fullName();
                    String name = definedClass.name();
                    String packageName = fullName.substring(0, fullName.length() - name.length());
                    path = packageName.toLowerCase() + name;
                } else {
                    path = definedClass.fullName();
                }
                File file = new File(targetDirectory, path.replace('.', File.separatorChar) + ".java");
                generatedFiles.add(file);
            }
        }
        return generatedFiles;
    }

    public static ClassLoader classLoaderFromResolverPath(String resolverPath) {
        ClassLoader classLoader;
        if (resolverPath == null) {
            classLoader = JavaCodeUtil.class.getClassLoader();
        } else {
            ArrayList<URL> list = new ArrayList<URL>();
            StringTokenizer tokenizer = new StringTokenizer(resolverPath, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                String s = tokenizer.nextToken();
                File file = new File(s);
                if (!file.exists() || !file.canRead()) {
                    _log.info("Path " + file + " does not exist or is not readable");
                    continue;
                }
                URI uri = file.toURI();
                try {
                    list.add(uri.toURL());
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException("URI " + uri + " derived from " + file + " should never be malformed");
                }
            }
            classLoader = URLClassLoader.newInstance(list.toArray(new URL[0]), JavaCodeUtil.class.getClassLoader());
        }
        return classLoader;
    }

    public static interface PersistentClassChecker {
        public boolean isPersistent(JDefinedClass var1);
    }
}

