/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataMap;
import com.linkedin.data.DataMapBuilder;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.JsonBuilder;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.SchemaToJsonEncoder;
import com.linkedin.data.schema.SchemaToPdlEncoder;
import com.linkedin.data.template.BooleanArray;
import com.linkedin.data.template.BooleanMap;
import com.linkedin.data.template.BytesArray;
import com.linkedin.data.template.BytesMap;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DirectArrayTemplate;
import com.linkedin.data.template.DirectMapTemplate;
import com.linkedin.data.template.DoubleArray;
import com.linkedin.data.template.DoubleMap;
import com.linkedin.data.template.FixedTemplate;
import com.linkedin.data.template.FloatArray;
import com.linkedin.data.template.FloatMap;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.IntegerArray;
import com.linkedin.data.template.IntegerMap;
import com.linkedin.data.template.LongArray;
import com.linkedin.data.template.LongMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.StringArray;
import com.linkedin.data.template.StringMap;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.data.template.UnionTemplate;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.data.template.WrappingMapTemplate;
import com.linkedin.data.transform.filter.FilterConstants;
import com.linkedin.pegasus.generator.CodeUtil;
import com.linkedin.pegasus.generator.JavaCodeGeneratorBase;
import com.linkedin.pegasus.generator.JavaCodeUtil;
import com.linkedin.pegasus.generator.ProjectionMaskApiChecker;
import com.linkedin.pegasus.generator.spec.ArrayTemplateSpec;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import com.linkedin.pegasus.generator.spec.CustomInfoSpec;
import com.linkedin.pegasus.generator.spec.EnumTemplateSpec;
import com.linkedin.pegasus.generator.spec.FixedTemplateSpec;
import com.linkedin.pegasus.generator.spec.MapTemplateSpec;
import com.linkedin.pegasus.generator.spec.ModifierSpec;
import com.linkedin.pegasus.generator.spec.PrimitiveTemplateSpec;
import com.linkedin.pegasus.generator.spec.RecordTemplateSpec;
import com.linkedin.pegasus.generator.spec.TyperefTemplateSpec;
import com.linkedin.pegasus.generator.spec.UnionTemplateSpec;
import com.linkedin.util.ArgumentUtil;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCase;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JMod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JSwitch;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaDataTemplateGenerator
extends JavaCodeGeneratorBase {
    public static final Map<DataSchema, Class<?>> PredefinedJavaClasses;
    private static final SchemaFormatType DEFAULT_SCHEMA_FORMAT_TYPE;
    private static final int DEFAULT_DATAMAP_INITIAL_CAPACITY = 16;
    private static final Logger _log;
    private static final String DEPRECATED_KEY = "deprecated";
    static final String PROJECTION_MASK_CLASSNAME = "ProjectionMask";
    private final Map<ClassTemplateSpec, JDefinedClass> _definedClasses = new HashMap<ClassTemplateSpec, JDefinedClass>();
    private final Map<JDefinedClass, ClassTemplateSpec> _generatedClasses = new HashMap<JDefinedClass, ClassTemplateSpec>();
    private final JClass _recordBaseClass = this.getCodeModel().ref(RecordTemplate.class);
    private final JClass _unionBaseClass = this.getCodeModel().ref(UnionTemplate.class);
    private final JClass _wrappingArrayBaseClass = this.getCodeModel().ref(WrappingArrayTemplate.class);
    private final JClass _wrappingMapBaseClass = this.getCodeModel().ref(WrappingMapTemplate.class);
    private final JClass _directArrayBaseClass = this.getCodeModel().ref(DirectArrayTemplate.class);
    private final JClass _directMapBaseClass = this.getCodeModel().ref(DirectMapTemplate.class);
    private final JClass _schemaFormatTypeClass = this.getCodeModel().ref(SchemaFormatType.class);
    private final boolean _recordFieldAccessorWithMode;
    private final boolean _recordFieldRemove;
    private final boolean _pathSpecMethods;
    private final boolean _fieldMaskMethods;
    private final boolean _copierMethods;
    private final String _rootPath;
    private final ProjectionMaskApiChecker _projectionMaskApiChecker;

    private JavaDataTemplateGenerator(String defaultPackage, boolean recordFieldAccessorWithMode, boolean recordFieldRemove, boolean pathSpecMethods, boolean copierMethods, String rootPath, boolean fieldMaskMethods, ProjectionMaskApiChecker projectionMaskApiChecker) {
        super(defaultPackage);
        this._recordFieldAccessorWithMode = recordFieldAccessorWithMode;
        this._recordFieldRemove = recordFieldRemove;
        this._pathSpecMethods = pathSpecMethods;
        this._fieldMaskMethods = fieldMaskMethods;
        this._copierMethods = copierMethods;
        this._rootPath = rootPath;
        this._projectionMaskApiChecker = projectionMaskApiChecker;
    }

    public JavaDataTemplateGenerator(Config config) {
        this(config.getDefaultPackage(), config.getRecordFieldAccessorWithMode(), config.getRecordFieldRemove(), config.getPathSpecMethods(), config.getCopierMethods(), config.getRootPath(), config.isFieldMaskMethods(), config.getProjectionMaskApiChecker());
    }

    public JavaDataTemplateGenerator(String defaultPackage) {
        this(defaultPackage, null);
    }

    public JavaDataTemplateGenerator(String defaultPackage, String rootPath) {
        this(defaultPackage, true, true, true, true, rootPath, false, null);
    }

    public Map<JDefinedClass, ClassTemplateSpec> getGeneratedClasses() {
        return this._generatedClasses;
    }

    public JClass generate(ClassTemplateSpec classTemplateSpec) {
        JClass result;
        if (classTemplateSpec == null) {
            result = null;
        } else if (classTemplateSpec.getSchema() == null) {
            result = this.getCodeModel().directClass(classTemplateSpec.getFullName());
        } else if (PredefinedJavaClasses.containsKey(classTemplateSpec.getSchema())) {
            Class<?> nativeJavaClass = PredefinedJavaClasses.get(classTemplateSpec.getSchema());
            result = this.getCodeModel().ref(nativeJavaClass);
        } else if (classTemplateSpec.getSchema().isPrimitive()) {
            result = this.generatePrimitive((PrimitiveTemplateSpec)classTemplateSpec);
        } else {
            try {
                JDefinedClass definedClass = this.defineClass(classTemplateSpec);
                this.populateClassContent(classTemplateSpec, definedClass);
                result = definedClass;
            }
            catch (JClassAlreadyExistsException e) {
                throw new IllegalArgumentException(classTemplateSpec.getFullName());
            }
        }
        return result;
    }

    private static JInvocation dataClassArg(JInvocation inv, JClass dataClass) {
        if (dataClass != null) {
            inv.arg(JExpr.dotclass((JClass)dataClass));
        }
        return inv;
    }

    private static void generateCopierMethods(JDefinedClass templateClass, Map<String, JVar> fields, JClass changeListenerClass) {
        JavaDataTemplateGenerator.overrideCopierMethod(templateClass, "clone", fields, false, changeListenerClass);
        JavaDataTemplateGenerator.overrideCopierMethod(templateClass, "copy", fields, true, changeListenerClass);
    }

    private static boolean hasNestedFields(DataSchema schema) {
        block6: while (true) {
            switch (schema.getDereferencedType()) {
                case RECORD: {
                    return true;
                }
                case UNION: {
                    return true;
                }
                case ARRAY: {
                    schema = ((ArrayDataSchema)schema.getDereferencedDataSchema()).getItems();
                    continue block6;
                }
                case MAP: {
                    schema = ((MapDataSchema)schema.getDereferencedDataSchema()).getValues();
                    continue block6;
                }
            }
            break;
        }
        return false;
    }

    private static boolean isArrayType(DataSchema schema) {
        return schema.getDereferencedType() == DataSchema.Type.ARRAY;
    }

    private static void generateConstructorWithNoArg(JDefinedClass cls, JClass newClass) {
        JMethod noArgConstructor = cls.constructor(1);
        noArgConstructor.body().invoke("this").arg((JExpression)JExpr._new((JClass)newClass));
    }

    private static void generateConstructorWithObjectArg(JDefinedClass cls, JVar schemaField, JVar changeListenerVar) {
        JMethod argConstructor = cls.constructor(1);
        JVar param = argConstructor.param(Object.class, "data");
        argConstructor.body().invoke("super").arg((JExpression)param).arg((JExpression)schemaField);
        if (changeListenerVar != null) {
            JavaDataTemplateGenerator.addChangeListenerRegistration(argConstructor, changeListenerVar);
        }
    }

    private static void generateConstructorWithArg(JDefinedClass cls, JVar schemaField, JClass paramClass, JVar changeListenerVar) {
        JMethod argConstructor = cls.constructor(1);
        JVar param = argConstructor.param((JType)paramClass, "data");
        argConstructor.body().invoke("super").arg((JExpression)param).arg((JExpression)schemaField);
        if (changeListenerVar != null) {
            JavaDataTemplateGenerator.addChangeListenerRegistration(argConstructor, changeListenerVar);
        }
    }

    private static void generateConstructorWithArg(JDefinedClass cls, JVar schemaField, JClass paramClass, JClass elementClass, JClass dataClass) {
        JMethod argConstructor = cls.constructor(1);
        JVar param = argConstructor.param((JType)paramClass, "data");
        JInvocation inv = argConstructor.body().invoke("super").arg((JExpression)param).arg((JExpression)schemaField).arg(JExpr.dotclass((JClass)elementClass));
        JavaDataTemplateGenerator.dataClassArg(inv, dataClass);
    }

    private static void addChangeListenerRegistration(JMethod constructor, JVar changeListenerVar) {
        constructor.body().invoke("addChangeListener").arg((JExpression)changeListenerVar);
    }

    private static DataSchema schemaForArrayItemsOrMapValues(CustomInfoSpec customInfo, DataSchema schema) {
        return customInfo != null ? customInfo.getCustomSchema() : schema.getDereferencedDataSchema();
    }

    private static void overrideCopierMethod(JDefinedClass templateClass, String methodName, Map<String, JVar> fields, boolean resetFields, JClass changeListenerClass) {
        JMethod copierMethod = templateClass.method(1, (JType)templateClass, methodName);
        copierMethod.annotate(Override.class);
        copierMethod._throws(CloneNotSupportedException.class);
        JVar copyVar = copierMethod.body().decl((JType)templateClass, "__" + methodName, (JExpression)JExpr.cast((JType)templateClass, (JExpression)JExpr._super().invoke(methodName)));
        if (!fields.isEmpty()) {
            if (resetFields) {
                fields.values().forEach(var -> copierMethod.body().assign((JAssignmentTarget)copyVar.ref(var), JExpr._null()));
            }
            copierMethod.body().assign((JAssignmentTarget)copyVar.ref("__changeListener"), (JExpression)JExpr._new((JClass)changeListenerClass).arg((JExpression)copyVar));
            copierMethod.body().add((JStatement)copyVar.invoke("addChangeListener").arg((JExpression)copyVar.ref("__changeListener")));
        }
        copierMethod.body()._return((JExpression)copyVar);
    }

    private static void setDeprecatedAnnotationAndJavadoc(DataSchema schema, JDefinedClass schemaClass) {
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(schema.getProperties().get(DEPRECATED_KEY), (JAnnotatable)schemaClass, (JDocCommentable)schemaClass);
    }

    private static void setDeprecatedAnnotationAndJavadoc(JMethod method, RecordDataSchema.Field field) {
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(field.getProperties().get(DEPRECATED_KEY), (JAnnotatable)method, (JDocCommentable)method);
    }

    private static void setDeprecatedAnnotationAndJavadoc(EnumDataSchema enumSchema, String symbol, JEnumConstant constant) {
        Object deprecatedSymbolsProp = enumSchema.getProperties().get("deprecatedSymbols");
        if (deprecatedSymbolsProp instanceof DataMap) {
            DataMap deprecatedSymbols = (DataMap)deprecatedSymbolsProp;
            Object deprecatedProp = deprecatedSymbols.get((Object)symbol);
            JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(deprecatedProp, (JAnnotatable)constant, (JDocCommentable)constant);
        }
    }

    private static void setDeprecatedAnnotationAndJavadoc(Object deprecatedProp, JAnnotatable annotatable, JDocCommentable commentable) {
        if (Boolean.TRUE.equals(deprecatedProp) && annotatable != null) {
            annotatable.annotate(Deprecated.class);
        } else if (deprecatedProp instanceof String) {
            if (commentable != null) {
                String deprecatedReason = (String)deprecatedProp;
                commentable.javadoc().addDeprecated().append((Object)deprecatedReason);
            }
            if (annotatable != null) {
                annotatable.annotate(Deprecated.class);
            }
        }
    }

    private static int getJModValue(Set<ModifierSpec> modifiers) {
        try {
            int value = 0;
            for (ModifierSpec mod : modifiers) {
                value |= JMod.class.getDeclaredField(mod.name()).getInt(null);
            }
            return value;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addAccessorDoc(JClass clazz, JMethod method, RecordDataSchema.Field field, String prefix) {
        method.javadoc().append((Object)(prefix + " for " + field.getName()));
        method.javadoc().addXdoclet("see " + clazz.name() + ".Fields#" + JavaDataTemplateGenerator.escapeReserved(field.getName()));
    }

    private JDefinedClass defineClass(ClassTemplateSpec classTemplateSpec) throws JClassAlreadyExistsException {
        JDefinedClass result = this._definedClasses.get(classTemplateSpec);
        if (result == null) {
            int jmodValue = JavaDataTemplateGenerator.getJModValue(classTemplateSpec.getModifiers());
            Object container = classTemplateSpec.getEnclosingClass() == null ? this.getPackage(classTemplateSpec.getPackage()) : this.defineClass(classTemplateSpec.getEnclosingClass());
            if (classTemplateSpec instanceof ArrayTemplateSpec || classTemplateSpec instanceof FixedTemplateSpec || classTemplateSpec instanceof MapTemplateSpec || classTemplateSpec instanceof RecordTemplateSpec || classTemplateSpec instanceof TyperefTemplateSpec || classTemplateSpec instanceof UnionTemplateSpec) {
                result = container._class(jmodValue, JavaDataTemplateGenerator.escapeReserved(classTemplateSpec.getClassName()));
            } else if (classTemplateSpec instanceof EnumTemplateSpec) {
                result = container._class(jmodValue, JavaDataTemplateGenerator.escapeReserved(classTemplateSpec.getClassName()), ClassType.ENUM);
            } else {
                throw new RuntimeException();
            }
            this._definedClasses.put(classTemplateSpec, result);
        }
        return result;
    }

    protected void generateArray(JDefinedClass arrayClass, ArrayTemplateSpec arrayDataTemplateSpec) throws JClassAlreadyExistsException {
        JClass itemJClass = this.generate(arrayDataTemplateSpec.getItemClass());
        JClass dataJClass = this.generate(arrayDataTemplateSpec.getItemDataClass());
        boolean isDirect = CodeUtil.isDirectType(arrayDataTemplateSpec.getSchema().getItems());
        if (isDirect) {
            arrayClass._extends(this._directArrayBaseClass.narrow(itemJClass));
        } else {
            this.extendWrappingArrayBaseClass(itemJClass, arrayClass);
        }
        ArrayDataSchema bareSchema = new ArrayDataSchema(JavaDataTemplateGenerator.schemaForArrayItemsOrMapValues(arrayDataTemplateSpec.getCustomInfo(), arrayDataTemplateSpec.getSchema().getItems()));
        JFieldVar schemaField = this.generateSchemaField(arrayClass, (DataSchema)bareSchema, arrayDataTemplateSpec.getSourceFileFormat());
        JavaDataTemplateGenerator.generateConstructorWithNoArg(arrayClass, this._dataListClass);
        this.generateConstructorWithInitialCapacity(arrayClass, this._dataListClass);
        this.generateConstructorWithCollection(arrayClass, itemJClass);
        JavaDataTemplateGenerator.generateConstructorWithArg(arrayClass, (JVar)schemaField, this._dataListClass, itemJClass, dataJClass);
        this.generateConstructorWithVarArgs(arrayClass, itemJClass);
        if (this._pathSpecMethods) {
            this.generatePathSpecMethodsForCollection(arrayClass, (DataSchema)arrayDataTemplateSpec.getSchema(), itemJClass, "items");
        }
        if (this._fieldMaskMethods) {
            this.generateMaskBuilderForCollection(arrayClass, (DataSchema)arrayDataTemplateSpec.getSchema(), itemJClass, "items", arrayDataTemplateSpec.getItemClass());
        }
        this.generateCustomClassInitialization(arrayClass, arrayDataTemplateSpec.getCustomInfo());
        if (this._copierMethods) {
            JavaDataTemplateGenerator.generateCopierMethods(arrayClass, Collections.emptyMap(), null);
        }
        this.generateCoercerOverrides(arrayClass, arrayDataTemplateSpec.getItemClass(), arrayDataTemplateSpec.getSchema().getItems(), arrayDataTemplateSpec.getCustomInfo(), false);
    }

    protected void extendWrappingArrayBaseClass(JClass itemJClass, JDefinedClass arrayClass) {
        arrayClass._extends(this._wrappingArrayBaseClass.narrow(itemJClass));
    }

    protected void generateEnum(JDefinedClass enumClass, EnumTemplateSpec enumSpec) {
        enumClass.javadoc().append((Object)enumSpec.getSchema().getDoc());
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc((DataSchema)enumSpec.getSchema(), enumClass);
        this.generateSchemaField(enumClass, (DataSchema)enumSpec.getSchema(), enumSpec.getSourceFileFormat());
        for (String value : enumSpec.getSchema().getSymbols()) {
            if (JavaDataTemplateGenerator.isReserved(value)) {
                throw new IllegalArgumentException("Enum contains Java reserved symbol: " + value + " schema: " + enumSpec.getSchema());
            }
            JEnumConstant enumConstant = enumClass.enumConstant(value);
            String enumConstantDoc = (String)enumSpec.getSchema().getSymbolDocs().get(value);
            if (enumConstantDoc != null) {
                enumConstant.javadoc().append((Object)enumConstantDoc);
            }
            JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(enumSpec.getSchema(), value, enumConstant);
        }
        enumClass.enumConstant("$UNKNOWN");
    }

    protected void generateFixed(JDefinedClass fixedClass, FixedTemplateSpec fixedSpec) {
        fixedClass.javadoc().append((Object)fixedSpec.getSchema().getDoc());
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc((DataSchema)fixedSpec.getSchema(), fixedClass);
        fixedClass._extends(FixedTemplate.class);
        JFieldVar schemaField = this.generateSchemaField(fixedClass, (DataSchema)fixedSpec.getSchema(), fixedSpec.getSourceFileFormat());
        JMethod bytesConstructor = fixedClass.constructor(1);
        JVar param = bytesConstructor.param(ByteString.class, "value");
        bytesConstructor.body().invoke("super").arg((JExpression)param).arg((JExpression)schemaField);
        JavaDataTemplateGenerator.generateConstructorWithObjectArg(fixedClass, (JVar)schemaField, null);
        if (this._copierMethods) {
            JavaDataTemplateGenerator.generateCopierMethods(fixedClass, Collections.emptyMap(), null);
        }
    }

    protected void generateMap(JDefinedClass mapClass, MapTemplateSpec mapSpec) throws JClassAlreadyExistsException {
        JClass valueJClass = this.generate(mapSpec.getValueClass());
        JClass dataJClass = this.generate(mapSpec.getValueDataClass());
        boolean isDirect = CodeUtil.isDirectType(mapSpec.getSchema().getValues());
        if (isDirect) {
            mapClass._extends(this._directMapBaseClass.narrow(valueJClass));
        } else {
            this.extendWrappingMapBaseClass(valueJClass, mapClass);
        }
        MapDataSchema bareSchema = new MapDataSchema(JavaDataTemplateGenerator.schemaForArrayItemsOrMapValues(mapSpec.getCustomInfo(), mapSpec.getSchema().getValues()));
        JFieldVar schemaField = this.generateSchemaField(mapClass, (DataSchema)bareSchema, mapSpec.getSourceFileFormat());
        JavaDataTemplateGenerator.generateConstructorWithNoArg(mapClass, this._dataMapClass);
        this.generateConstructorWithInitialCapacity(mapClass, this._dataMapClass);
        this.generateConstructorWithInitialCapacityAndLoadFactor(mapClass);
        this.generateConstructorWithMap(mapClass, valueJClass);
        JavaDataTemplateGenerator.generateConstructorWithArg(mapClass, (JVar)schemaField, this._dataMapClass, valueJClass, dataJClass);
        if (this._pathSpecMethods) {
            this.generatePathSpecMethodsForCollection(mapClass, (DataSchema)mapSpec.getSchema(), valueJClass, "values");
        }
        if (this._fieldMaskMethods) {
            this.generateMaskBuilderForCollection(mapClass, (DataSchema)mapSpec.getSchema(), valueJClass, "values", mapSpec.getValueClass());
        }
        this.generateCustomClassInitialization(mapClass, mapSpec.getCustomInfo());
        if (this._copierMethods) {
            JavaDataTemplateGenerator.generateCopierMethods(mapClass, Collections.emptyMap(), null);
        }
        this.generateCoercerOverrides(mapClass, mapSpec.getValueClass(), mapSpec.getSchema().getValues(), mapSpec.getCustomInfo(), true);
    }

    protected void extendWrappingMapBaseClass(JClass valueJClass, JDefinedClass mapClass) {
        mapClass._extends(this._wrappingMapBaseClass.narrow(valueJClass));
    }

    private JClass generatePrimitive(PrimitiveTemplateSpec primitiveSpec) {
        switch (primitiveSpec.getSchema().getType()) {
            case INT: {
                return this.getCodeModel().INT.boxify();
            }
            case DOUBLE: {
                return this.getCodeModel().DOUBLE.boxify();
            }
            case BOOLEAN: {
                return this.getCodeModel().BOOLEAN.boxify();
            }
            case STRING: {
                return this._stringClass;
            }
            case LONG: {
                return this.getCodeModel().LONG.boxify();
            }
            case FLOAT: {
                return this.getCodeModel().FLOAT.boxify();
            }
            case BYTES: {
                return this._byteStringClass;
            }
        }
        throw new RuntimeException("Not supported primitive: " + primitiveSpec);
    }

    protected void generateRecord(JDefinedClass templateClass, RecordTemplateSpec recordSpec) throws JClassAlreadyExistsException {
        JFieldVar changeListenerVar;
        JClass changeListenerClass;
        templateClass.javadoc().append((Object)recordSpec.getSchema().getDoc());
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc((DataSchema)recordSpec.getSchema(), templateClass);
        this.extendRecordBaseClass(templateClass);
        if (this._pathSpecMethods) {
            this.generatePathSpecMethodsForRecord(recordSpec.getFields(), templateClass);
        }
        if (this._fieldMaskMethods) {
            this.generateMaskBuilderForRecord(recordSpec.getFields(), templateClass);
        }
        JFieldVar schemaFieldVar = this.generateSchemaField(templateClass, (DataSchema)recordSpec.getSchema(), recordSpec.getSourceFileFormat());
        HashMap<String, JVar> fieldVarMap = new HashMap<String, JVar>();
        for (RecordTemplateSpec.Field field : recordSpec.getFields()) {
            String fieldName = field.getSchemaField().getName();
            JFieldVar fieldVar = templateClass.field(4, (JType)this.generate(field.getType()), "_" + fieldName + "Field", JExpr._null());
            fieldVarMap.put(fieldName, (JVar)fieldVar);
        }
        if (!fieldVarMap.isEmpty()) {
            changeListenerClass = this.generateChangeListener(templateClass, fieldVarMap);
            changeListenerVar = templateClass.field(4, (JType)changeListenerClass, "__changeListener", (JExpression)JExpr._new((JClass)changeListenerClass).arg(JExpr._this()));
        } else {
            changeListenerClass = null;
            changeListenerVar = null;
        }
        this.generateDataMapConstructor(templateClass, (JVar)schemaFieldVar, recordSpec.getFields().size(), recordSpec.getWrappedFields().size(), (JVar)changeListenerVar);
        JavaDataTemplateGenerator.generateConstructorWithArg(templateClass, (JVar)schemaFieldVar, this._dataMapClass, (JVar)changeListenerVar);
        recordSpec.getFields().stream().map(RecordTemplateSpec.Field::getCustomInfo).distinct().forEach(customInfo -> this.generateCustomClassInitialization(templateClass, (CustomInfoSpec)customInfo));
        for (RecordTemplateSpec.Field field : recordSpec.getFields()) {
            String fieldName = field.getSchemaField().getName();
            this.generateRecordFieldAccessors(templateClass, field, this.generate(field.getType()), (JVar)schemaFieldVar, (JVar)fieldVarMap.get(fieldName));
        }
        if (this._copierMethods) {
            JavaDataTemplateGenerator.generateCopierMethods(templateClass, fieldVarMap, changeListenerClass);
        }
    }

    private void generateDataMapConstructor(JDefinedClass cls, JVar schemaField, int initialDataMapSize, int initialCacheSize, JVar changeListenerVar) {
        JMethod noArgConstructor = cls.constructor(1);
        JInvocation superConstructorArg = JExpr._new((JClass)this._dataMapClass);
        int initialDataMapCapacity = DataMapBuilder.getOptimumHashMapCapacityFromSize((int)initialDataMapSize);
        if (initialDataMapCapacity < 16) {
            superConstructorArg.arg(JExpr.lit((int)initialDataMapCapacity));
            superConstructorArg.arg(JExpr.lit((float)0.75f));
        }
        int initialCacheCapacity = DataMapBuilder.getOptimumHashMapCapacityFromSize((int)initialCacheSize);
        if (initialCacheSize > 0 && initialCacheCapacity < 16) {
            noArgConstructor.body().invoke("super").arg((JExpression)superConstructorArg).arg((JExpression)schemaField).arg(JExpr.lit((int)initialCacheCapacity));
        } else {
            noArgConstructor.body().invoke("super").arg((JExpression)superConstructorArg).arg((JExpression)schemaField);
        }
        if (changeListenerVar != null) {
            JavaDataTemplateGenerator.addChangeListenerRegistration(noArgConstructor, changeListenerVar);
        }
    }

    protected void extendRecordBaseClass(JDefinedClass templateClass) {
        templateClass._extends(this._recordBaseClass);
    }

    private void generateMaskBuilderForRecord(List<RecordTemplateSpec.Field> fieldSpecs, JDefinedClass templateClass) throws JClassAlreadyExistsException {
        JDefinedClass maskNestedClass = this.generateProjectionMaskNestedClass(templateClass, fieldSpecs.size());
        for (RecordTemplateSpec.Field field : fieldSpecs) {
            this.generateWithFieldBodyNested(field, maskNestedClass, method -> {});
            this.generateWithFieldBodyDefault(field, maskNestedClass, method -> method.body().invoke((JExpression)JExpr.invoke((String)"getDataMap"), "put").arg(field.getSchemaField().getName()).arg((JExpression)this.getCodeModel().ref(MaskMap.class).staticRef("POSITIVE_MASK")));
            if (!JavaDataTemplateGenerator.isArrayType(field.getSchemaField().getType())) continue;
            this.generateWithFieldBodyNested(field, maskNestedClass, withFieldRangeMethod -> this.generateArrayFieldAttributeMethod(field, (JMethod)withFieldRangeMethod));
            this.generateWithFieldBodyDefault(field, maskNestedClass, withFieldRangeMethod -> {
                withFieldRangeMethod.body().invoke((JExpression)JExpr.invoke((String)"getDataMap"), "put").arg(field.getSchemaField().getName()).arg((JExpression)JExpr._new((JClass)this.getCodeModel().ref(DataMap.class)).arg(JExpr.lit((int)DataMapBuilder.getOptimumHashMapCapacityFromSize((int)2))));
                this.generateArrayFieldAttributeMethod(field, (JMethod)withFieldRangeMethod);
            });
        }
    }

    private void generateArrayFieldAttributeMethod(RecordTemplateSpec.Field field, JMethod withFieldRangeMethod) {
        JVar start = withFieldRangeMethod.param((JType)this.getCodeModel().ref(Integer.class), "start");
        JVar count = withFieldRangeMethod.param((JType)this.getCodeModel().ref(Integer.class), "count");
        JInvocation getDataMap = JExpr.invoke((String)"getDataMap").invoke("getDataMap").arg(field.getSchemaField().getName());
        JBlock startBlock = withFieldRangeMethod.body()._if(start.ne(JExpr._null()))._then();
        startBlock.invoke((JExpression)getDataMap, "put").arg("$start").arg((JExpression)start);
        JBlock countBlock = withFieldRangeMethod.body()._if(count.ne(JExpr._null()))._then();
        countBlock.invoke((JExpression)getDataMap, "put").arg("$count").arg((JExpression)count);
    }

    private void generateWithFieldBodyNested(RecordTemplateSpec.Field field, JDefinedClass maskNestedClass, Consumer<JMethod> methodBodyCustomizer) {
        if (JavaDataTemplateGenerator.hasNestedFields(field.getSchemaField().getType())) {
            JClass fieldType = this.generate(field.getType());
            JClass nestedMaskType = this.getCodeModel().ref(fieldType.fullName() + "." + PROJECTION_MASK_CLASSNAME);
            String fieldName = JavaDataTemplateGenerator.escapeReserved(field.getSchemaField().getName());
            String maskFieldName = "_" + fieldName + "Mask";
            JInvocation getDataMap = JExpr.invoke((String)"getDataMap");
            if (this.hasProjectionMaskApi(fieldType, field.getType())) {
                JFieldVar maskField = (JFieldVar)maskNestedClass.fields().get(maskFieldName);
                if (maskField == null) {
                    maskField = maskNestedClass.field(4, (JType)nestedMaskType, maskFieldName);
                }
                JMethod withFieldTypesafeMethod = maskNestedClass.method(1, (JType)maskNestedClass, "with" + CodeUtil.capitalize(JavaDataTemplateGenerator.escapeReserved(fieldName)));
                if (!field.getSchemaField().getDoc().isEmpty()) {
                    withFieldTypesafeMethod.javadoc().append((Object)field.getSchemaField().getDoc());
                }
                JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(withFieldTypesafeMethod, field.getSchemaField());
                JVar nestedMask = withFieldTypesafeMethod.param((JType)this.getCodeModel().ref(Function.class).narrow(new JClass[]{nestedMaskType, nestedMaskType}), "nestedMask");
                withFieldTypesafeMethod.body().assign((JAssignmentTarget)maskField, (JExpression)nestedMask.invoke("apply").arg(JOp.cond((JExpression)maskField.eq(JExpr._null()), (JExpression)fieldType.staticInvoke("createMask"), (JExpression)maskField)));
                withFieldTypesafeMethod.body().invoke((JExpression)getDataMap, "put").arg(fieldName).arg((JExpression)maskField.invoke("getDataMap"));
                methodBodyCustomizer.accept(withFieldTypesafeMethod);
                withFieldTypesafeMethod.body()._return(JExpr._this());
            }
            if (this.shouldGenerateGenericMaskApi(field.getType())) {
                JMethod withFieldMethod = maskNestedClass.method(1, (JType)maskNestedClass, "with" + CodeUtil.capitalize(JavaDataTemplateGenerator.escapeReserved(fieldName)));
                if (!field.getSchemaField().getDoc().isEmpty()) {
                    withFieldMethod.javadoc().append((Object)field.getSchemaField().getDoc());
                }
                JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(withFieldMethod, field.getSchemaField());
                JVar maskMap = withFieldMethod.param((JType)this._maskMapClass, "nestedMask");
                withFieldMethod.body().invoke((JExpression)getDataMap, "put").arg(fieldName).arg((JExpression)maskMap.invoke("getDataMap"));
                methodBodyCustomizer.accept(withFieldMethod);
                withFieldMethod.body()._return(JExpr._this());
            }
        }
    }

    private boolean hasProjectionMaskApi(JClass parentClass, ClassTemplateSpec templateSpec) {
        return this._projectionMaskApiChecker != null && this._projectionMaskApiChecker.hasProjectionMaskApi(parentClass, templateSpec);
    }

    private boolean shouldGenerateGenericMaskApi(ClassTemplateSpec templateSpec) {
        return this._projectionMaskApiChecker == null || !this._projectionMaskApiChecker.isGeneratedFromSource(templateSpec);
    }

    private void generateWithFieldBodyDefault(RecordTemplateSpec.Field field, JDefinedClass maskNestedClass, Consumer<JMethod> methodCustomizer) {
        String fieldName = JavaDataTemplateGenerator.escapeReserved(field.getSchemaField().getName());
        JMethod withFieldMethod = maskNestedClass.method(1, (JType)maskNestedClass, "with" + CodeUtil.capitalize(fieldName));
        if (!field.getSchemaField().getDoc().isEmpty()) {
            withFieldMethod.javadoc().append((Object)field.getSchemaField().getDoc());
        }
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(withFieldMethod, field.getSchemaField());
        String maskFieldName = "_" + fieldName + "Mask";
        JFieldVar maskField = (JFieldVar)maskNestedClass.fields().get(maskFieldName);
        if (maskField != null) {
            withFieldMethod.body().assign((JAssignmentTarget)maskField, JExpr._null());
        }
        methodCustomizer.accept(withFieldMethod);
        withFieldMethod.body()._return(JExpr._this());
    }

    private void generatePathSpecMethodsForRecord(List<RecordTemplateSpec.Field> fieldSpecs, JDefinedClass templateClass) throws JClassAlreadyExistsException {
        JDefinedClass fieldsNestedClass = this.generatePathSpecNestedClass(templateClass);
        for (RecordTemplateSpec.Field field : fieldSpecs) {
            JClass fieldsRefType = this._pathSpecClass;
            if (JavaDataTemplateGenerator.hasNestedFields(field.getSchemaField().getType())) {
                JClass fieldType = this.generate(field.getType());
                fieldsRefType = this.getCodeModel().ref(fieldType.fullName() + ".Fields");
            }
            JMethod constantField = fieldsNestedClass.method(1, (JType)fieldsRefType, JavaDataTemplateGenerator.escapeReserved(field.getSchemaField().getName()));
            constantField.body()._return((JExpression)JExpr._new((JClass)fieldsRefType).arg((JExpression)JExpr.invoke((String)"getPathComponents")).arg(field.getSchemaField().getName()));
            if (!field.getSchemaField().getDoc().isEmpty()) {
                constantField.javadoc().append((Object)field.getSchemaField().getDoc());
            }
            JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(constantField, field.getSchemaField());
            if (!JavaDataTemplateGenerator.isArrayType(field.getSchemaField().getType())) continue;
            JMethod pathSpecRangeMethod = fieldsNestedClass.method(1, (JType)this._pathSpecClass, JavaDataTemplateGenerator.escapeReserved(field.getSchemaField().getName()));
            JVar arrayPathSpec = pathSpecRangeMethod.body().decl((JType)this._pathSpecClass, "arrayPathSpec", (JExpression)JExpr._new((JClass)this._pathSpecClass).arg((JExpression)JExpr.invoke((String)"getPathComponents")).arg(field.getSchemaField().getName()));
            JClass integerClass = this.generate(PrimitiveTemplateSpec.getInstance(DataSchema.Type.INT));
            JVar start = pathSpecRangeMethod.param((JType)integerClass, "start");
            pathSpecRangeMethod.body()._if(start.ne(JExpr._null()))._then().invoke((JExpression)arrayPathSpec, "setAttribute").arg("start").arg((JExpression)start);
            JVar count = pathSpecRangeMethod.param((JType)integerClass, "count");
            pathSpecRangeMethod.body()._if(count.ne(JExpr._null()))._then().invoke((JExpression)arrayPathSpec, "setAttribute").arg("count").arg((JExpression)count);
            pathSpecRangeMethod.body()._return((JExpression)arrayPathSpec);
            if (!field.getSchemaField().getDoc().isEmpty()) {
                pathSpecRangeMethod.javadoc().append((Object)field.getSchemaField().getDoc());
            }
            JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(pathSpecRangeMethod, field.getSchemaField());
        }
        JVar staticFields = templateClass.field(28, (JType)fieldsNestedClass, "_fields").init((JExpression)JExpr._new((JClass)fieldsNestedClass));
        JMethod staticFieldsAccessor = templateClass.method(17, (JType)fieldsNestedClass, "fields");
        staticFieldsAccessor.body()._return((JExpression)staticFields);
    }

    private void generateRecordFieldAccessors(JDefinedClass templateClass, RecordTemplateSpec.Field field, JClass type, JVar schemaFieldVar, JVar fieldVar) {
        JVar param;
        JFieldVar defaultField;
        RecordDataSchema.Field schemaField = field.getSchemaField();
        DataSchema fieldSchema = schemaField.getType();
        String capitalizedName = CodeUtil.capitalize(schemaField.getName());
        JFieldRef mapRef = JExpr._super().ref("_map");
        JExpression fieldNameExpr = JExpr.lit((String)schemaField.getName());
        String fieldFieldName = "FIELD_" + capitalizedName;
        JFieldVar fieldField = templateClass.field(28, RecordDataSchema.Field.class, fieldFieldName);
        fieldField.init((JExpression)schemaFieldVar.invoke("getField").arg(schemaField.getName()));
        String defaultFieldName = "DEFAULT_" + capitalizedName;
        if (field.getSchemaField().getDefault() != null) {
            defaultField = templateClass.field(28, (JType)type, defaultFieldName);
            templateClass.init().assign((JAssignmentTarget)defaultField, this.getCoerceOutputExpression((JExpression)fieldField.invoke("getDefault"), schemaField.getType(), type, field.getCustomInfo()));
        } else {
            defaultField = null;
        }
        JMethod has = templateClass.method(1, (JType)this.getCodeModel().BOOLEAN, "has" + capitalizedName);
        JavaDataTemplateGenerator.addAccessorDoc((JClass)templateClass, has, schemaField, "Existence checker");
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(has, schemaField);
        JBlock hasBody = has.body();
        JBlock hasInstanceVarBody = hasBody._if(fieldVar.ne(JExpr._null()))._then();
        hasInstanceVarBody._return(JExpr.lit((boolean)true));
        hasBody._return((JExpression)mapRef.invoke("containsKey").arg(fieldNameExpr));
        if (this._recordFieldRemove) {
            String removeName = "remove" + capitalizedName;
            JMethod remove = templateClass.method(1, (JType)this.getCodeModel().VOID, removeName);
            JavaDataTemplateGenerator.addAccessorDoc((JClass)templateClass, remove, schemaField, "Remover");
            JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(remove, schemaField);
            JBlock removeBody = remove.body();
            removeBody.add((JStatement)mapRef.invoke("remove").arg(fieldNameExpr));
        }
        String getterName = JavaCodeUtil.getGetterName(this.getCodeModel(), (JType)type, capitalizedName);
        if (this._recordFieldAccessorWithMode) {
            JMethod getterWithMode = templateClass.method(1, (JType)type, getterName);
            JavaDataTemplateGenerator.addAccessorDoc((JClass)templateClass, getterWithMode, schemaField, "Getter");
            JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(getterWithMode, schemaField);
            JVar modeParam = getterWithMode.param((JType)this._getModeClass, "mode");
            JBlock getterWithModeBody = getterWithMode.body();
            if (field.getSchemaField().getOptional() && defaultField == null) {
                getterWithModeBody._return((JExpression)JExpr.invoke((String)getterName));
            } else {
                JSwitch modeSwitch = getterWithModeBody._switch((JExpression)modeParam);
                JCase strictCase = modeSwitch._case((JExpression)JExpr.ref((String)"STRICT"));
                if (defaultField == null) {
                    strictCase.body()._return((JExpression)JExpr.invoke((String)getterName));
                }
                JCase defaultCase = modeSwitch._case((JExpression)JExpr.ref((String)"DEFAULT"));
                if (defaultField != null) {
                    defaultCase.body()._return((JExpression)JExpr.invoke((String)getterName));
                }
                JCase nullCase = modeSwitch._case((JExpression)JExpr.ref((String)"NULL"));
                JConditional nullCaseConditional = nullCase.body()._if(fieldVar.ne(JExpr._null()));
                nullCaseConditional._then()._return((JExpression)fieldVar);
                JBlock nullCaseConditionalElse = nullCaseConditional._else();
                JVar rawValueVar = nullCaseConditionalElse.decl((JType)this._objectClass, "__rawValue", (JExpression)mapRef.invoke("get").arg(fieldNameExpr));
                nullCaseConditionalElse.assign((JAssignmentTarget)fieldVar, this.getCoerceOutputExpression((JExpression)rawValueVar, fieldSchema, type, field.getCustomInfo()));
                nullCaseConditionalElse._return((JExpression)fieldVar);
                getterWithModeBody._throw((JExpression)JExpr._new((JClass)this.getCodeModel().ref(IllegalStateException.class)).arg(JExpr.lit((String)"Unknown mode ").plus((JExpression)modeParam)));
            }
        }
        JMethod getterWithoutMode = templateClass.method(1, (JType)type, getterName);
        JavaDataTemplateGenerator.addAccessorDoc((JClass)templateClass, getterWithoutMode, schemaField, "Getter");
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(getterWithoutMode, schemaField);
        JCommentPart returnComment = getterWithoutMode.javadoc().addReturn();
        if (schemaField.getOptional()) {
            getterWithoutMode.annotate(Nullable.class);
            returnComment.add((Object)"Optional field. Always check for null.");
        } else {
            getterWithoutMode.annotate(Nonnull.class);
            returnComment.add((Object)"Required field. Could be null for partial record.");
        }
        JBlock getterWithoutModeBody = getterWithoutMode.body();
        JConditional getterWithoutModeBodyConditional = getterWithoutModeBody._if(fieldVar.ne(JExpr._null()));
        getterWithoutModeBodyConditional._then()._return((JExpression)fieldVar);
        JBlock getterWithoutModeBodyConditionalElse = getterWithoutModeBodyConditional._else();
        JVar rawValueVar = getterWithoutModeBodyConditionalElse.decl((JType)this._objectClass, "__rawValue", (JExpression)mapRef.invoke("get").arg(fieldNameExpr));
        if (schemaField.getDefault() != null) {
            getterWithoutModeBodyConditionalElse._if(rawValueVar.eq(JExpr._null()))._then()._return((JExpression)defaultField);
        } else if (!schemaField.getOptional()) {
            getterWithoutModeBodyConditionalElse._if(rawValueVar.eq(JExpr._null()))._then()._throw((JExpression)JExpr._new((JClass)this.getCodeModel().ref(RequiredFieldNotPresentException.class)).arg(fieldNameExpr));
        }
        getterWithoutModeBodyConditionalElse.assign((JAssignmentTarget)fieldVar, this.getCoerceOutputExpression((JExpression)rawValueVar, fieldSchema, type, field.getCustomInfo()));
        getterWithoutModeBodyConditionalElse._return((JExpression)fieldVar);
        String setterName = "set" + capitalizedName;
        if (this._recordFieldAccessorWithMode) {
            JMethod setterWithMode = templateClass.method(1, (JType)templateClass, setterName);
            JavaDataTemplateGenerator.addAccessorDoc((JClass)templateClass, setterWithMode, schemaField, "Setter");
            JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(setterWithMode, schemaField);
            param = setterWithMode.param((JType)type, "value");
            JVar modeParam = setterWithMode.param((JType)this._setModeClass, "mode");
            JSwitch modeSwitch = setterWithMode.body()._switch((JExpression)modeParam);
            JCase disallowNullCase = modeSwitch._case((JExpression)JExpr.ref((String)"DISALLOW_NULL"));
            disallowNullCase.body()._return((JExpression)JExpr.invoke((String)setterName).arg((JExpression)param));
            JCase removeOptionalIfNullCase = modeSwitch._case((JExpression)JExpr.ref((String)"REMOVE_OPTIONAL_IF_NULL"));
            if (!schemaField.getOptional()) {
                JConditional paramIsNull = removeOptionalIfNullCase.body()._if(param.eq(JExpr._null()));
                paramIsNull._then()._throw((JExpression)JExpr._new((JClass)this.getCodeModel().ref(IllegalArgumentException.class)).arg(JExpr.lit((String)("Cannot remove mandatory field " + schemaField.getName() + " of " + templateClass.fullName()))));
                paramIsNull._else().add((JStatement)this._checkedUtilClass.staticInvoke("putWithoutChecking").arg((JExpression)mapRef).arg(fieldNameExpr).arg(this.getCoerceInputExpression((JExpression)param, fieldSchema, field.getCustomInfo())));
                paramIsNull._else().assign((JAssignmentTarget)fieldVar, (JExpression)param);
                removeOptionalIfNullCase.body()._break();
            }
            JCase removeIfNullCase = modeSwitch._case((JExpression)JExpr.ref((String)"REMOVE_IF_NULL"));
            JConditional paramIsNull = removeIfNullCase.body()._if(param.eq(JExpr._null()));
            paramIsNull._then().invoke("remove" + capitalizedName);
            paramIsNull._else().add((JStatement)this._checkedUtilClass.staticInvoke("putWithoutChecking").arg((JExpression)mapRef).arg(fieldNameExpr).arg(this.getCoerceInputExpression((JExpression)param, fieldSchema, field.getCustomInfo())));
            paramIsNull._else().assign((JAssignmentTarget)fieldVar, (JExpression)param);
            removeIfNullCase.body()._break();
            JCase ignoreNullCase = modeSwitch._case((JExpression)JExpr.ref((String)"IGNORE_NULL"));
            JConditional paramIsNotNull = ignoreNullCase.body()._if(param.ne(JExpr._null()));
            paramIsNotNull._then().add((JStatement)this._checkedUtilClass.staticInvoke("putWithoutChecking").arg((JExpression)mapRef).arg(fieldNameExpr).arg(this.getCoerceInputExpression((JExpression)param, fieldSchema, field.getCustomInfo())));
            paramIsNotNull._then().assign((JAssignmentTarget)fieldVar, (JExpression)param);
            ignoreNullCase.body()._break();
            setterWithMode.body()._return(JExpr._this());
        }
        JMethod setter = templateClass.method(1, (JType)templateClass, setterName);
        JavaDataTemplateGenerator.addAccessorDoc((JClass)templateClass, setter, schemaField, "Setter");
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(setter, schemaField);
        param = setter.param((JType)type, "value");
        param.annotate(Nonnull.class);
        JCommentPart paramDoc = setter.javadoc().addParam(param);
        paramDoc.add((Object)"Must not be null. For more control, use setters with mode instead.");
        JConditional paramIsNull = setter.body()._if(param.eq(JExpr._null()));
        paramIsNull._then()._throw((JExpression)JExpr._new((JClass)this.getCodeModel().ref(NullPointerException.class)).arg(JExpr.lit((String)("Cannot set field " + schemaField.getName() + " of " + templateClass.fullName() + " to null"))));
        paramIsNull._else().add((JStatement)this._checkedUtilClass.staticInvoke("putWithoutChecking").arg((JExpression)mapRef).arg(fieldNameExpr).arg(this.getCoerceInputExpression((JExpression)param, fieldSchema, field.getCustomInfo())));
        paramIsNull._else().assign((JAssignmentTarget)fieldVar, (JExpression)param);
        setter.body()._return(JExpr._this());
        if (!type.unboxify().equals(type)) {
            JMethod unboxifySetter = templateClass.method(1, (JType)templateClass, setterName);
            JavaDataTemplateGenerator.addAccessorDoc((JClass)templateClass, unboxifySetter, schemaField, "Setter");
            JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(unboxifySetter, schemaField);
            param = unboxifySetter.param(type.unboxify(), "value");
            unboxifySetter.body().add((JStatement)this._checkedUtilClass.staticInvoke("putWithoutChecking").arg((JExpression)mapRef).arg(fieldNameExpr).arg(this.getCoerceInputExpression((JExpression)param, fieldSchema, field.getCustomInfo())));
            unboxifySetter.body().assign((JAssignmentTarget)fieldVar, (JExpression)param);
            unboxifySetter.body()._return(JExpr._this());
        }
    }

    protected void generateTyperef(JDefinedClass typerefClass, TyperefTemplateSpec typerefSpec) {
        typerefClass.javadoc().append((Object)typerefSpec.getSchema().getDoc());
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc((DataSchema)typerefSpec.getSchema(), typerefClass);
        typerefClass._extends(TyperefInfo.class);
        JFieldVar schemaField = this.generateSchemaField(typerefClass, (DataSchema)typerefSpec.getSchema(), typerefSpec.getSourceFileFormat());
        this.generateCustomClassInitialization(typerefClass, typerefSpec.getCustomInfo());
        JMethod constructor = typerefClass.constructor(1);
        constructor.body().invoke("super").arg((JExpression)schemaField);
    }

    protected void generateUnion(JDefinedClass unionClass, UnionTemplateSpec unionSpec) throws JClassAlreadyExistsException {
        JFieldVar changeListenerVar;
        JClass changeListenerClass;
        this.extendUnionBaseClass(unionClass);
        JFieldVar schemaField = this.generateSchemaField(unionClass, (DataSchema)unionSpec.getSchema(), unionSpec.getSourceFileFormat());
        HashMap<String, JVar> memberVarMap = new HashMap<String, JVar>();
        for (UnionTemplateSpec.Member member : unionSpec.getMembers()) {
            if (member.getClassTemplateSpec() == null) continue;
            String memberName = CodeUtil.uncapitalize(CodeUtil.getUnionMemberName(member));
            JFieldVar memberVar = unionClass.field(4, (JType)this.generate(member.getClassTemplateSpec()), "_" + (String)memberName + "Member", JExpr._null());
            memberVarMap.put(member.getUnionMemberKey(), (JVar)memberVar);
        }
        if (!memberVarMap.isEmpty()) {
            changeListenerClass = this.generateChangeListener(unionClass, memberVarMap);
            changeListenerVar = unionClass.field(4, (JType)changeListenerClass, "__changeListener", (JExpression)JExpr._new((JClass)changeListenerClass).arg(JExpr._this()));
        } else {
            changeListenerClass = null;
            changeListenerVar = null;
        }
        this.generateDataMapConstructor(unionClass, (JVar)schemaField, 1, -1, (JVar)changeListenerVar);
        JavaDataTemplateGenerator.generateConstructorWithObjectArg(unionClass, (JVar)schemaField, (JVar)changeListenerVar);
        for (UnionTemplateSpec.Member member : unionSpec.getMembers()) {
            if (member.getClassTemplateSpec() == null) continue;
            this.generateUnionMemberAccessors(unionClass, member, this.generate(member.getClassTemplateSpec()), this.generate(member.getDataClass()), (JVar)schemaField, (JVar)memberVarMap.get(member.getUnionMemberKey()));
        }
        unionSpec.getMembers().stream().map(UnionTemplateSpec.Member::getCustomInfo).distinct().forEach(customInfo -> this.generateCustomClassInitialization(unionClass, (CustomInfoSpec)customInfo));
        if (this._pathSpecMethods) {
            this.generatePathSpecMethodsForUnion(unionSpec, unionClass);
        }
        if (this._fieldMaskMethods) {
            this.generateMaskBuilderForUnion(unionSpec, unionClass);
        }
        if (this._copierMethods) {
            JavaDataTemplateGenerator.generateCopierMethods(unionClass, memberVarMap, changeListenerClass);
        }
        if (unionSpec.getTyperefClass() != null) {
            TyperefTemplateSpec typerefClassSpec = unionSpec.getTyperefClass();
            JDefinedClass typerefInfoClass = unionClass._class(JavaDataTemplateGenerator.getJModValue(typerefClassSpec.getModifiers()), JavaDataTemplateGenerator.escapeReserved(typerefClassSpec.getClassName()));
            this.generateTyperef(typerefInfoClass, typerefClassSpec);
            JFieldVar typerefInfoField = unionClass.field(28, TyperefInfo.class, "TYPEREFINFO");
            typerefInfoField.init((JExpression)JExpr._new((JClass)typerefInfoClass));
            unionClass._implements(HasTyperefInfo.class);
            JMethod typerefInfoMethod = unionClass.method(1, TyperefInfo.class, "typerefInfo");
            typerefInfoMethod.body()._return((JExpression)typerefInfoField);
        }
    }

    protected void extendUnionBaseClass(JDefinedClass unionClass) {
        unionClass._extends(this._unionBaseClass);
    }

    private void generateUnionMemberAccessors(JDefinedClass unionClass, UnionTemplateSpec.Member member, JClass memberClass, JClass dataClass, JVar schemaField, JVar memberVar) {
        DataSchema memberType = member.getSchema();
        String memberKey = member.getUnionMemberKey();
        String capitalizedName = CodeUtil.getUnionMemberName(member);
        JFieldRef mapRef = JExpr._super().ref("_map");
        String memberFieldName = "MEMBER_" + capitalizedName;
        JFieldVar memberField = unionClass.field(28, DataSchema.class, memberFieldName);
        memberField.init((JExpression)schemaField.invoke("getTypeByMemberKey").arg(memberKey));
        String memberFieldKeyName = "MEMBERKEY_" + capitalizedName;
        unionClass.field(25, String.class, memberFieldKeyName, JExpr.lit((String)memberKey));
        String setterName = "set" + capitalizedName;
        String builderMethodName = member.getAlias() != null ? "createWith" + capitalizedName : "create";
        JMethod createMethod = unionClass.method(17, (JType)unionClass, builderMethodName);
        JVar param = createMethod.param((JType)memberClass, "value");
        JVar newUnionVar = createMethod.body().decl((JType)unionClass, "newUnion", (JExpression)JExpr._new((JClass)unionClass));
        createMethod.body().invoke((JExpression)newUnionVar, setterName).arg((JExpression)param);
        createMethod.body()._return((JExpression)newUnionVar);
        JMethod is = unionClass.method(1, (JType)this.getCodeModel().BOOLEAN, "is" + capitalizedName);
        JBlock isBody = is.body();
        JInvocation res = JExpr.invoke((String)"memberIs").arg(JExpr.lit((String)memberKey));
        isBody._return((JExpression)res);
        String getterName = "get" + capitalizedName;
        JMethod getter = unionClass.method(1, (JType)memberClass, getterName);
        JBlock getterBody = getter.body();
        getterBody.invoke("checkNotNull");
        JBlock memberVarNonNullBlock = getterBody._if(memberVar.ne(JExpr._null()))._then();
        memberVarNonNullBlock._return((JExpression)memberVar);
        JVar rawValueVar = getterBody.decl((JType)this._objectClass, "__rawValue", (JExpression)mapRef.invoke("get").arg(JExpr.lit((String)memberKey)));
        getterBody.assign((JAssignmentTarget)memberVar, this.getCoerceOutputExpression((JExpression)rawValueVar, memberType, memberClass, member.getCustomInfo()));
        getterBody._return((JExpression)memberVar);
        JMethod setter = unionClass.method(1, Void.TYPE, setterName);
        param = setter.param((JType)memberClass, "value");
        JBlock setterBody = setter.body();
        setterBody.invoke("checkNotNull");
        setterBody.add((JStatement)mapRef.invoke("clear"));
        setterBody.assign((JAssignmentTarget)memberVar, (JExpression)param);
        setterBody.add((JStatement)this._checkedUtilClass.staticInvoke("putWithoutChecking").arg((JExpression)mapRef).arg(JExpr.lit((String)memberKey)).arg(this.getCoerceInputExpression((JExpression)param, memberType, member.getCustomInfo())));
    }

    private void generateMaskBuilderForUnion(UnionTemplateSpec unionSpec, JDefinedClass unionClass) throws JClassAlreadyExistsException {
        JDefinedClass maskNestedClass = this.generateProjectionMaskNestedClass(unionClass, unionSpec.getMembers().size());
        for (UnionTemplateSpec.Member member : unionSpec.getMembers()) {
            String memberKey = member.getUnionMemberKey();
            String methodName = CodeUtil.getUnionMemberName(member);
            JInvocation getDataMap = JExpr.invoke((String)"getDataMap");
            if (JavaDataTemplateGenerator.hasNestedFields(member.getSchema())) {
                JClass memberType = this.generate(member.getClassTemplateSpec());
                if (this.shouldGenerateGenericMaskApi(member.getClassTemplateSpec())) {
                    JMethod withMemberMethod = maskNestedClass.method(1, (JType)maskNestedClass, "with" + CodeUtil.capitalize(JavaDataTemplateGenerator.escapeReserved(methodName)));
                    JVar maskMap = withMemberMethod.param((JType)this._maskMapClass, "nestedMask");
                    withMemberMethod.body().invoke((JExpression)getDataMap, "put").arg(memberKey).arg((JExpression)maskMap.invoke("getDataMap"));
                    withMemberMethod.body()._return(JExpr._this());
                }
                if (!this.hasProjectionMaskApi(memberType, member.getClassTemplateSpec())) continue;
                JClass nestedMaskType = this.getCodeModel().ref(memberType.fullName() + "." + PROJECTION_MASK_CLASSNAME);
                JMethod withMemberTypesafeMethod = maskNestedClass.method(1, (JType)maskNestedClass, "with" + CodeUtil.capitalize(JavaDataTemplateGenerator.escapeReserved(methodName)));
                String maskFieldName = "_" + CodeUtil.capitalize(JavaDataTemplateGenerator.escapeReserved(methodName)) + "Mask";
                JFieldVar maskField = maskNestedClass.field(4, (JType)nestedMaskType, maskFieldName);
                JVar nestedMask = withMemberTypesafeMethod.param((JType)this.getCodeModel().ref(Function.class).narrow(new JClass[]{nestedMaskType, nestedMaskType}), "nestedMask");
                withMemberTypesafeMethod.body().assign((JAssignmentTarget)maskField, (JExpression)nestedMask.invoke("apply").arg(JOp.cond((JExpression)maskField.eq(JExpr._null()), (JExpression)memberType.staticInvoke("createMask"), (JExpression)maskField)));
                withMemberTypesafeMethod.body().invoke((JExpression)getDataMap, "put").arg(memberKey).arg((JExpression)maskField.invoke("getDataMap"));
                withMemberTypesafeMethod.body()._return(JExpr._this());
                continue;
            }
            JMethod withMemberMethod = maskNestedClass.method(1, (JType)maskNestedClass, "with" + CodeUtil.capitalize(JavaDataTemplateGenerator.escapeReserved(methodName)));
            withMemberMethod.body().invoke((JExpression)getDataMap, "put").arg(memberKey).arg((JExpression)this.getCodeModel().ref(MaskMap.class).staticRef("POSITIVE_MASK"));
            withMemberMethod.body()._return(JExpr._this());
        }
    }

    private void generatePathSpecMethodsForUnion(UnionTemplateSpec unionSpec, JDefinedClass unionClass) throws JClassAlreadyExistsException {
        JDefinedClass fieldsNestedClass = this.generatePathSpecNestedClass(unionClass);
        for (UnionTemplateSpec.Member member : unionSpec.getMembers()) {
            JClass fieldsRefType = this._pathSpecClass;
            if (JavaDataTemplateGenerator.hasNestedFields(member.getSchema())) {
                JClass unionMemberClass = this.generate(member.getClassTemplateSpec());
                fieldsRefType = this.getCodeModel().ref(unionMemberClass.fullName() + ".Fields");
            }
            String memberKey = member.getUnionMemberKey();
            String methodName = CodeUtil.getUnionMemberName(member);
            JMethod accessorMethod = fieldsNestedClass.method(1, (JType)fieldsRefType, methodName);
            accessorMethod.body()._return((JExpression)JExpr._new((JClass)fieldsRefType).arg((JExpression)JExpr.invoke((String)"getPathComponents")).arg(memberKey));
        }
    }

    private void populateClassContent(ClassTemplateSpec classTemplateSpec, JDefinedClass definedClass) throws JClassAlreadyExistsException {
        if (!this._generatedClasses.containsKey(definedClass)) {
            this._generatedClasses.put(definedClass, classTemplateSpec);
            JavaCodeUtil.annotate(definedClass, "Data Template", classTemplateSpec.getLocation(), this._rootPath);
            if (classTemplateSpec instanceof ArrayTemplateSpec) {
                this.generateArray(definedClass, (ArrayTemplateSpec)classTemplateSpec);
            } else if (classTemplateSpec instanceof EnumTemplateSpec) {
                this.generateEnum(definedClass, (EnumTemplateSpec)classTemplateSpec);
            } else if (classTemplateSpec instanceof FixedTemplateSpec) {
                this.generateFixed(definedClass, (FixedTemplateSpec)classTemplateSpec);
            } else if (classTemplateSpec instanceof MapTemplateSpec) {
                this.generateMap(definedClass, (MapTemplateSpec)classTemplateSpec);
            } else if (classTemplateSpec instanceof RecordTemplateSpec) {
                this.generateRecord(definedClass, (RecordTemplateSpec)classTemplateSpec);
            } else if (classTemplateSpec instanceof TyperefTemplateSpec) {
                this.generateTyperef(definedClass, (TyperefTemplateSpec)classTemplateSpec);
            } else if (classTemplateSpec instanceof UnionTemplateSpec) {
                this.generateUnion(definedClass, (UnionTemplateSpec)classTemplateSpec);
            } else {
                throw new RuntimeException();
            }
        }
    }

    private JFieldVar generateSchemaField(JDefinedClass templateClass, DataSchema schema, SchemaFormatType sourceFormatType) {
        String schemaText;
        SchemaFormatType schemaFormatType = Optional.ofNullable(sourceFormatType).orElse(DEFAULT_SCHEMA_FORMAT_TYPE);
        JFieldRef schemaFormatTypeRef = this._schemaFormatTypeClass.staticRef(schemaFormatType.name());
        JFieldVar schemaField = templateClass.field(28, schema.getClass(), "SCHEMA");
        switch (schemaFormatType) {
            case PDSC: {
                schemaText = SchemaToJsonEncoder.schemaToJson((DataSchema)schema, (JsonBuilder.Pretty)JsonBuilder.Pretty.COMPACT);
                break;
            }
            case PDL: {
                schemaText = SchemaToPdlEncoder.schemaToPdl((DataSchema)schema, (SchemaToPdlEncoder.EncodingStyle)SchemaToPdlEncoder.EncodingStyle.COMPACT);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unrecognized schema format type '%s'", schemaFormatType));
            }
        }
        JInvocation parseSchemaInvocation = this._dataTemplateUtilClass.staticInvoke("parseSchema").arg(this.getSizeBoundStringLiteral(schemaText));
        if (schemaFormatType != SchemaFormatType.PDSC) {
            parseSchemaInvocation.arg((JExpression)schemaFormatTypeRef);
        }
        schemaField.init((JExpression)JExpr.cast((JType)this.getCodeModel()._ref(schema.getClass()), (JExpression)parseSchemaInvocation));
        JMethod staticFieldsAccessor = templateClass.method(17, schema.getClass(), "dataSchema");
        staticFieldsAccessor.body()._return((JExpression)schemaField);
        return schemaField;
    }

    private void generateMaskBuilderForCollection(JDefinedClass templateClass, DataSchema schema, JClass childClass, String wildcardMethodName, ClassTemplateSpec itemSpec) throws JClassAlreadyExistsException {
        if (JavaDataTemplateGenerator.hasNestedFields(schema)) {
            JDefinedClass maskNestedClass = this.generateProjectionMaskNestedClass(templateClass, FilterConstants.ARRAY_ATTRIBUTES.size() + 1);
            JInvocation getDataMap = JExpr.invoke((String)"getDataMap");
            if (this.hasProjectionMaskApi(childClass, itemSpec)) {
                JMethod withFieldTypesafeMethod = maskNestedClass.method(1, (JType)maskNestedClass, "with" + CodeUtil.capitalize(wildcardMethodName));
                JClass nestedMaskType = this.getCodeModel().ref(childClass.fullName() + "." + PROJECTION_MASK_CLASSNAME);
                JFieldVar maskField = maskNestedClass.field(4, (JType)nestedMaskType, "_" + wildcardMethodName + "Mask");
                JVar nestedMask = withFieldTypesafeMethod.param((JType)this.getCodeModel().ref(Function.class).narrow(new JClass[]{nestedMaskType, nestedMaskType}), "nestedMask");
                withFieldTypesafeMethod.body().assign((JAssignmentTarget)maskField, (JExpression)nestedMask.invoke("apply").arg(JOp.cond((JExpression)maskField.eq(JExpr._null()), (JExpression)childClass.staticInvoke("createMask"), (JExpression)maskField)));
                withFieldTypesafeMethod.body().invoke((JExpression)getDataMap, "put").arg(JExpr.lit((String)"$*")).arg((JExpression)maskField.invoke("getDataMap"));
                withFieldTypesafeMethod.body()._return(JExpr._this());
            }
            if (this.shouldGenerateGenericMaskApi(itemSpec)) {
                JMethod withFieldMethod = maskNestedClass.method(1, (JType)maskNestedClass, "with" + CodeUtil.capitalize(wildcardMethodName));
                JVar maskMap = withFieldMethod.param((JType)this._maskMapClass, "nestedMask");
                withFieldMethod.body().invoke((JExpression)getDataMap, "put").arg(JExpr.lit((String)"$*")).arg((JExpression)maskMap.invoke("getDataMap"));
                withFieldMethod.body()._return(JExpr._this());
            }
        }
    }

    private void generatePathSpecMethodsForCollection(JDefinedClass templateClass, DataSchema schema, JClass childClass, String wildcardMethodName) throws JClassAlreadyExistsException {
        if (JavaDataTemplateGenerator.hasNestedFields(schema)) {
            JDefinedClass fieldsNestedClass = this.generatePathSpecNestedClass(templateClass);
            JClass itemsFieldType = this.getCodeModel().ref(childClass.fullName() + ".Fields");
            JMethod constantField = fieldsNestedClass.method(1, (JType)itemsFieldType, wildcardMethodName);
            constantField.body()._return((JExpression)JExpr._new((JClass)itemsFieldType).arg((JExpression)JExpr.invoke((String)"getPathComponents")).arg((JExpression)this._pathSpecClass.staticRef("WILDCARD")));
        }
    }

    private JDefinedClass generatePathSpecNestedClass(JDefinedClass templateClass) throws JClassAlreadyExistsException {
        JDefinedClass fieldsNestedClass = templateClass._class(17, "Fields");
        fieldsNestedClass._extends(this._pathSpecClass);
        JMethod constructor = fieldsNestedClass.constructor(1);
        JClass listString = this.getCodeModel().ref(List.class).narrow(String.class);
        JVar namespace = constructor.param((JType)listString, "path");
        JVar name = constructor.param(String.class, "name");
        constructor.body().invoke("super").arg((JExpression)namespace).arg((JExpression)name);
        fieldsNestedClass.constructor(1).body().invoke("super");
        return fieldsNestedClass;
    }

    private JDefinedClass generateProjectionMaskNestedClass(JDefinedClass templateClass, int fieldCount) throws JClassAlreadyExistsException {
        JDefinedClass projectionMaskNestedClass = templateClass._class(17, PROJECTION_MASK_CLASSNAME);
        projectionMaskNestedClass._extends(this._maskMapClass);
        JMethod constructor = projectionMaskNestedClass.constructor(0);
        if (DataMapBuilder.getOptimumHashMapCapacityFromSize((int)fieldCount) < 16) {
            constructor.body().invoke("super").arg(JExpr.lit((int)DataMapBuilder.getOptimumHashMapCapacityFromSize((int)fieldCount)));
        }
        JMethod createMaskMethod = templateClass.method(17, (JType)projectionMaskNestedClass, "createMask");
        createMaskMethod.body()._return((JExpression)JExpr._new((JClass)projectionMaskNestedClass));
        return projectionMaskNestedClass;
    }

    private void generateCustomClassInitialization(JDefinedClass templateClass, CustomInfoSpec customInfo) {
        if (customInfo != null) {
            String customClassFullName = customInfo.getCustomClass().getNamespace() + "." + customInfo.getCustomClass().getClassName();
            templateClass.init().add((JStatement)this._customClass.staticInvoke("initializeCustomClass").arg(this.getCodeModel().ref(customClassFullName).dotclass()));
            if (customInfo.getCoercerClass() != null) {
                String coercerClassFullName = customInfo.getCoercerClass().getNamespace() + "." + customInfo.getCoercerClass().getClassName();
                templateClass.init().add((JStatement)this._customClass.staticInvoke("initializeCoercerClass").arg(this.getCodeModel().ref(coercerClassFullName).dotclass()));
            }
        }
    }

    protected void generateCoercerOverrides(JDefinedClass wrapperClass, ClassTemplateSpec itemSpec, DataSchema itemSchema, CustomInfoSpec customInfoSpec, boolean tolerateNullForCoerceOutput) {
        JClass valueType = this.generate(itemSpec);
        if (CodeUtil.isDirectType(itemSchema)) {
            JMethod coerceInput = wrapperClass.method(2, (JType)this._objectClass, "coerceInput");
            JVar inputParam = coerceInput.param((JType)valueType, "object");
            coerceInput._throws(ClassCastException.class);
            coerceInput.annotate(Override.class);
            coerceInput.body().add((JStatement)this.getCodeModel().directClass(ArgumentUtil.class.getCanonicalName()).staticInvoke("notNull").arg((JExpression)inputParam).arg("object"));
            coerceInput.body()._return(this.getCoerceInputExpression((JExpression)inputParam, itemSchema, customInfoSpec));
        }
        JMethod coerceOutput = wrapperClass.method(2, (JType)valueType, "coerceOutput");
        JVar outputParam = coerceOutput.param((JType)this._objectClass, "object");
        coerceOutput._throws(TemplateOutputCastException.class);
        coerceOutput.annotate(Override.class);
        if (tolerateNullForCoerceOutput) {
            coerceOutput.body()._if(outputParam.eq(JExpr._null()))._then()._return(JExpr._null());
        } else {
            coerceOutput.body().directStatement("assert(object != null);");
        }
        coerceOutput.body()._return(this.getCoerceOutputExpression((JExpression)outputParam, itemSchema, valueType, customInfoSpec));
    }

    private void generateConstructorWithInitialCapacity(JDefinedClass cls, JClass elementClass) {
        JMethod argConstructor = cls.constructor(1);
        JVar initialCapacity = argConstructor.param((JType)this.getCodeModel().INT, "initialCapacity");
        argConstructor.body().invoke("this").arg((JExpression)JExpr._new((JClass)elementClass).arg((JExpression)initialCapacity));
    }

    private void generateConstructorWithCollection(JDefinedClass cls, JClass elementClass) {
        JMethod argConstructor = cls.constructor(1);
        JVar c = argConstructor.param((JType)this._collectionClass.narrow(elementClass), "c");
        argConstructor.body().invoke("this").arg((JExpression)JExpr._new((JClass)this._dataListClass).arg((JExpression)c.invoke("size")));
        argConstructor.body().invoke("addAll").arg((JExpression)c);
    }

    private void generateConstructorWithVarArgs(JDefinedClass cls, JClass elementClass) {
        JMethod argConstructor = cls.constructor(1);
        JVar first = argConstructor.param((JType)elementClass, "first");
        JVar rest = argConstructor.varParam((JType)elementClass, "rest");
        argConstructor.body().invoke("this").arg((JExpression)JExpr._new((JClass)this._dataListClass).arg(rest.ref("length").plus(JExpr.lit((int)1))));
        argConstructor.body().invoke("add").arg((JExpression)first);
        argConstructor.body().invoke("addAll").arg((JExpression)this._arraysClass.staticInvoke("asList").arg((JExpression)rest));
    }

    private void generateConstructorWithInitialCapacityAndLoadFactor(JDefinedClass cls) {
        JMethod argConstructor = cls.constructor(1);
        JVar initialCapacity = argConstructor.param((JType)this.getCodeModel().INT, "initialCapacity");
        JVar loadFactor = argConstructor.param((JType)this.getCodeModel().FLOAT, "loadFactor");
        argConstructor.body().invoke("this").arg((JExpression)JExpr._new((JClass)this._dataMapClass).arg((JExpression)initialCapacity).arg((JExpression)loadFactor));
    }

    private void generateConstructorWithMap(JDefinedClass cls, JClass valueClass) {
        JMethod argConstructor = cls.constructor(1);
        JVar m = argConstructor.param((JType)this._mapClass.narrow(new JClass[]{this._stringClass, valueClass}), "m");
        argConstructor.body().invoke("this").arg((JExpression)JExpr.invoke((String)"newDataMapOfSize").arg((JExpression)m.invoke("size")));
        argConstructor.body().invoke("putAll").arg((JExpression)m);
    }

    private JClass generateChangeListener(JDefinedClass cls, Map<String, JVar> fieldMap) throws JClassAlreadyExistsException {
        JClass changeListenerInterface = this.getCodeModel().ref(CheckedMap.ChangeListener.class);
        JDefinedClass changeListenerClass = cls._class(20, "ChangeListener");
        changeListenerClass._implements(changeListenerInterface.narrow(new Class[]{String.class, Object.class}));
        JFieldVar objectRefVar = changeListenerClass.field(12, (JType)cls, "__objectRef");
        JMethod constructor = changeListenerClass.constructor(4);
        JVar refParam = constructor.param((JType)cls, "reference");
        constructor.body().assign((JAssignmentTarget)objectRefVar, (JExpression)refParam);
        JMethod method = changeListenerClass.method(1, Void.TYPE, "onUnderlyingMapChanged");
        method.annotate(Override.class);
        JVar keyParam = method.param(String.class, "key");
        method.param((JType)this._objectClass, "value");
        JSwitch keySwitch = method.body()._switch((JExpression)keyParam);
        fieldMap.forEach((key, field) -> {
            JCase keyCase = keySwitch._case(JExpr.lit((String)key));
            keyCase.body().assign((JAssignmentTarget)objectRefVar.ref(field.name()), JExpr._null());
            keyCase.body()._break();
        });
        return changeListenerClass;
    }

    private JExpression getCoerceOutputExpression(JExpression rawExpr, DataSchema schema, JClass typeClass, CustomInfoSpec customInfoSpec) {
        if (CodeUtil.isDirectType(schema)) {
            if (customInfoSpec == null) {
                switch (schema.getDereferencedType()) {
                    case INT: {
                        return this._dataTemplateUtilClass.staticInvoke("coerceIntOutput").arg(rawExpr);
                    }
                    case FLOAT: {
                        return this._dataTemplateUtilClass.staticInvoke("coerceFloatOutput").arg(rawExpr);
                    }
                    case LONG: {
                        return this._dataTemplateUtilClass.staticInvoke("coerceLongOutput").arg(rawExpr);
                    }
                    case DOUBLE: {
                        return this._dataTemplateUtilClass.staticInvoke("coerceDoubleOutput").arg(rawExpr);
                    }
                    case BYTES: {
                        return this._dataTemplateUtilClass.staticInvoke("coerceBytesOutput").arg(rawExpr);
                    }
                    case BOOLEAN: {
                        return this._dataTemplateUtilClass.staticInvoke("coerceBooleanOutput").arg(rawExpr);
                    }
                    case STRING: {
                        return this._dataTemplateUtilClass.staticInvoke("coerceStringOutput").arg(rawExpr);
                    }
                    case ENUM: {
                        return this._dataTemplateUtilClass.staticInvoke("coerceEnumOutput").arg(rawExpr).arg(typeClass.dotclass()).arg((JExpression)typeClass.staticRef("$UNKNOWN"));
                    }
                }
            }
            JClass customClass = this.generate(customInfoSpec.getCustomClass());
            return this._dataTemplateUtilClass.staticInvoke("coerceCustomOutput").arg(rawExpr).arg(customClass.dotclass());
        }
        switch (schema.getDereferencedType()) {
            case RECORD: 
            case MAP: {
                return JOp.cond((JExpression)rawExpr.eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)JExpr._new((JClass)typeClass).arg((JExpression)this._dataTemplateUtilClass.staticInvoke("castOrThrow").arg(rawExpr).arg(this._dataMapClass.dotclass())));
            }
            case ARRAY: {
                return JOp.cond((JExpression)rawExpr.eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)JExpr._new((JClass)typeClass).arg((JExpression)this._dataTemplateUtilClass.staticInvoke("castOrThrow").arg(rawExpr).arg(this._dataListClass.dotclass())));
            }
            case UNION: 
            case FIXED: {
                return JOp.cond((JExpression)rawExpr.eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)JExpr._new((JClass)typeClass).arg(rawExpr));
            }
        }
        throw new TemplateOutputCastException("Cannot handle wrapped schema of type " + schema.getDereferencedType());
    }

    private JExpression getCoerceInputExpression(JExpression objectExpr, DataSchema schema, CustomInfoSpec customInfoSpec) {
        if (CodeUtil.isDirectType(schema)) {
            if (customInfoSpec == null) {
                switch (schema.getDereferencedType()) {
                    case INT: {
                        return this._dataTemplateUtilClass.staticInvoke("coerceIntInput").arg(objectExpr);
                    }
                    case FLOAT: {
                        return this._dataTemplateUtilClass.staticInvoke("coerceFloatInput").arg(objectExpr);
                    }
                    case LONG: {
                        return this._dataTemplateUtilClass.staticInvoke("coerceLongInput").arg(objectExpr);
                    }
                    case DOUBLE: {
                        return this._dataTemplateUtilClass.staticInvoke("coerceDoubleInput").arg(objectExpr);
                    }
                    case BOOLEAN: 
                    case STRING: 
                    case BYTES: {
                        return objectExpr;
                    }
                    case ENUM: {
                        return objectExpr.invoke("name");
                    }
                }
            }
            JClass customClass = this.generate(customInfoSpec.getCustomClass());
            return this._dataTemplateUtilClass.staticInvoke("coerceCustomInput").arg(objectExpr).arg(customClass.dotclass());
        }
        return objectExpr.invoke("data");
    }

    static {
        Class[] predefinedClass = new Class[]{BooleanArray.class, BooleanMap.class, BytesArray.class, BytesMap.class, DoubleArray.class, DoubleMap.class, FloatArray.class, FloatMap.class, IntegerArray.class, IntegerMap.class, LongArray.class, LongMap.class, StringArray.class, StringMap.class};
        PredefinedJavaClasses = new HashMap();
        for (Class clazz : predefinedClass) {
            DataSchema schema = DataTemplateUtil.getSchema((Class)clazz);
            PredefinedJavaClasses.put(schema, clazz);
        }
        DEFAULT_SCHEMA_FORMAT_TYPE = SchemaFormatType.PDSC;
        _log = LoggerFactory.getLogger(JavaDataTemplateGenerator.class);
    }

    public static class Config {
        private String _defaultPackage = null;
        private boolean _recordFieldAccessorWithMode = true;
        private boolean _recordFieldRemove = true;
        private boolean _pathSpecMethods = true;
        private boolean _fieldMaskMethods = false;
        private boolean _copierMethods = true;
        private String _rootPath = null;
        private ProjectionMaskApiChecker _projectionMaskApiChecker;

        public void setDefaultPackage(String defaultPackage) {
            this._defaultPackage = defaultPackage;
        }

        public String getDefaultPackage() {
            return this._defaultPackage;
        }

        public void setRecordFieldAccessorWithMode(boolean recordFieldAccessorWithMode) {
            this._recordFieldAccessorWithMode = recordFieldAccessorWithMode;
        }

        public boolean getRecordFieldAccessorWithMode() {
            return this._recordFieldAccessorWithMode;
        }

        public void setRecordFieldRemove(boolean recordFieldRemove) {
            this._recordFieldRemove = recordFieldRemove;
        }

        public boolean getRecordFieldRemove() {
            return this._recordFieldRemove;
        }

        public void setPathSpecMethods(boolean pathSpecMethods) {
            this._pathSpecMethods = pathSpecMethods;
        }

        public boolean getPathSpecMethods() {
            return this._pathSpecMethods;
        }

        public boolean isFieldMaskMethods() {
            return this._fieldMaskMethods;
        }

        public void setFieldMaskMethods(boolean fieldMaskMethods) {
            this._fieldMaskMethods = fieldMaskMethods;
        }

        public void setCopierMethods(boolean copierMethods) {
            this._copierMethods = copierMethods;
        }

        public boolean getCopierMethods() {
            return this._copierMethods;
        }

        public void setRootPath(String rootPath) {
            this._rootPath = rootPath;
        }

        public String getRootPath() {
            return this._rootPath;
        }

        public ProjectionMaskApiChecker getProjectionMaskApiChecker() {
            return this._projectionMaskApiChecker;
        }

        public void setProjectionMaskApiChecker(ProjectionMaskApiChecker projectionMaskApiChecker) {
            this._projectionMaskApiChecker = projectionMaskApiChecker;
        }
    }
}

