/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.internal.tools.ArgumentFileProcessor;
import com.linkedin.pegasus.generator.CaseSensitiveFileCodeWriter;
import com.linkedin.pegasus.generator.DataSchemaParser;
import com.linkedin.pegasus.generator.DataTemplatePersistentClassChecker;
import com.linkedin.pegasus.generator.DefaultGeneratorResult;
import com.linkedin.pegasus.generator.GeneratorResult;
import com.linkedin.pegasus.generator.JavaCodeUtil;
import com.linkedin.pegasus.generator.JavaDataTemplateGenerator;
import com.linkedin.pegasus.generator.ProjectionMaskApiChecker;
import com.linkedin.pegasus.generator.TemplateSpecGenerator;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import com.linkedin.util.FileUtil;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class PegasusDataTemplateGenerator {
    public static final String GENERATOR_GENERATE_IMPORTED = "generator.generate.imported";
    public static final String GENERATOR_GENERATE_LOWERCASE_PATH = "generator.generate.lowercase.path";
    public static final String GENERATOR_GENERATE_FIELD_MASK = "generator.generate.field.mask";
    private static final Logger _log = LoggerFactory.getLogger(PegasusDataTemplateGenerator.class);

    public static void main(String[] args) throws IOException {
        String generateImportedProperty;
        if (args.length < 2) {
            _log.error("Usage: PegasusDataTemplateGenerator targetDirectoryPath [sourceFile or sourceDirectory or schemaName]+");
            System.exit(1);
        }
        boolean generateImported = (generateImportedProperty = System.getProperty(GENERATOR_GENERATE_IMPORTED)) == null ? true : Boolean.parseBoolean(generateImportedProperty);
        String generateLowercasePathProperty = System.getProperty(GENERATOR_GENERATE_LOWERCASE_PATH);
        boolean generateLowercasePath = generateLowercasePathProperty == null ? true : Boolean.parseBoolean(generateLowercasePathProperty);
        String generateFieldMaskProperty = System.getProperty(GENERATOR_GENERATE_FIELD_MASK);
        boolean generateFieldMask = Boolean.parseBoolean(generateFieldMaskProperty);
        String resolverPath = System.getProperty("generator.resolver.path");
        if (resolverPath != null && ArgumentFileProcessor.isArgFile((String)resolverPath)) {
            String[] argFileContents = ArgumentFileProcessor.getContentsAsArray((String)resolverPath);
            resolverPath = argFileContents.length > 0 ? argFileContents[0] : null;
        }
        _log.debug("Resolver Path: " + resolverPath);
        String[] schemaFiles = Arrays.copyOfRange(args, 1, args.length);
        PegasusDataTemplateGenerator.run(resolverPath, System.getProperty("generator.default.package"), System.getProperty("root.path"), generateImported, args[0], schemaFiles, generateLowercasePath, generateFieldMask);
    }

    public static GeneratorResult run(String resolverPath, String defaultPackage, String rootPath, boolean generateImported, String targetDirectoryPath, String[] sources, boolean generateLowercasePath, boolean generateFieldMask) throws IOException {
        List<File> modifiedFiles;
        DataSchemaParser schemaParser = new DataSchemaParser.Builder(resolverPath).build();
        TemplateSpecGenerator specGenerator = new TemplateSpecGenerator(schemaParser.getSchemaResolver());
        JavaDataTemplateGenerator.Config config = new JavaDataTemplateGenerator.Config();
        config.setDefaultPackage(defaultPackage);
        config.setRootPath(rootPath);
        config.setFieldMaskMethods(generateFieldMask);
        for (DataSchema dataSchema : JavaDataTemplateGenerator.PredefinedJavaClasses.keySet()) {
            specGenerator.registerDefinedSchema(dataSchema);
        }
        DataSchemaParser.ParseResult parseResult = schemaParser.parseSources(sources);
        for (Map.Entry<DataSchema, DataSchemaLocation> entry : parseResult.getSchemaAndLocations().entrySet()) {
            specGenerator.generate(entry.getKey(), entry.getValue());
        }
        config.setProjectionMaskApiChecker(new ProjectionMaskApiChecker(specGenerator, parseResult.getSourceFiles(), JavaCodeUtil.classLoaderFromResolverPath(schemaParser.getResolverPath())));
        JavaDataTemplateGenerator javaDataTemplateGenerator = new JavaDataTemplateGenerator(config);
        for (ClassTemplateSpec spec : specGenerator.getGeneratedSpecs()) {
            javaDataTemplateGenerator.generate(spec);
        }
        DataTemplatePersistentClassChecker dataTemplatePersistentClassChecker = new DataTemplatePersistentClassChecker(generateImported, specGenerator, javaDataTemplateGenerator, parseResult.getSourceFiles());
        File targetDirectory = new File(targetDirectoryPath);
        List<File> targetFiles = JavaCodeUtil.targetFiles(targetDirectory, javaDataTemplateGenerator.getCodeModel(), JavaCodeUtil.classLoaderFromResolverPath(schemaParser.getResolverPath()), dataTemplatePersistentClassChecker, generateLowercasePath);
        if (FileUtil.upToDate(parseResult.getSourceFiles(), targetFiles)) {
            modifiedFiles = Collections.emptyList();
            _log.info("Target files are up-to-date: " + targetFiles);
        } else {
            modifiedFiles = targetFiles;
            _log.info("Generating " + targetFiles.size() + " files");
            _log.debug("Files: " + targetFiles);
            PegasusDataTemplateGenerator.validateDefinedClassRegistration(javaDataTemplateGenerator.getCodeModel(), javaDataTemplateGenerator.getGeneratedClasses().keySet());
            targetDirectory.mkdirs();
            javaDataTemplateGenerator.getCodeModel().build((CodeWriter)new CaseSensitiveFileCodeWriter(targetDirectory, true, generateLowercasePath));
        }
        return new DefaultGeneratorResult(parseResult.getSourceFiles(), targetFiles, modifiedFiles);
    }

    private static void validateDefinedClassRegistration(JCodeModel codeModel, Collection<JDefinedClass> classes) {
        Iterator packageIterator = codeModel.packages();
        while (packageIterator.hasNext()) {
            JPackage currentPackage = (JPackage)packageIterator.next();
            Iterator classIterator = currentPackage.classes();
            while (classIterator.hasNext()) {
                JDefinedClass currentClass = (JDefinedClass)classIterator.next();
                if (classes.contains(currentClass)) continue;
                throw new IllegalStateException("Attempting to generate unregistered class: '" + currentClass.fullName() + "'");
            }
        }
    }
}

