/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator;

import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.pegasus.generator.TemplateSpecGenerator;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import com.sun.codemodel.JClass;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ProjectionMaskApiChecker {
    private final TemplateSpecGenerator _specGenerator;
    private final Set<String> _sourceFiles;
    private final ClassLoader _classLoader;
    private final Map<JClass, Boolean> _hasProjectionMaskCache = new HashMap<JClass, Boolean>();

    ProjectionMaskApiChecker(TemplateSpecGenerator specGenerator, Set<File> sourceFiles, ClassLoader classLoader) {
        this._specGenerator = specGenerator;
        this._sourceFiles = sourceFiles.stream().map(File::getAbsolutePath).collect(Collectors.toSet());
        this._classLoader = classLoader;
    }

    boolean hasProjectionMaskApi(JClass definedClass, ClassTemplateSpec templateSpec) {
        return this._hasProjectionMaskCache.computeIfAbsent(definedClass, jClass -> {
            try {
                Class<?> clazz = this._classLoader.loadClass(jClass.fullName());
                return Arrays.stream(clazz.getClasses()).anyMatch(c -> c.getSimpleName().equals("ProjectionMask"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.isGeneratedFromSource(templateSpec);
            }
        });
    }

    boolean isGeneratedFromSource(ClassTemplateSpec templateSpec) {
        DataSchemaLocation location = this._specGenerator.getClassLocation(templateSpec);
        return location != null && this._sourceFiles.contains(location.getSourceFile().getAbsolutePath());
    }
}

