/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.avro.translators;

import com.github.fge.avro.translators.AvroTranslator;
import com.github.fge.avro.translators.AvroTranslators;
import com.github.fge.avro.translators.CustomArrayAvroTranslator;
import com.github.fge.avro.translators.CustomByteTranslator;
import com.github.fge.avro.translators.CustomFixedTranslator;
import com.github.fge.avro.translators.CustomIntTranslator;
import com.github.fge.avro.translators.CustomLongAvroTranslator;
import com.github.fge.avro.translators.CustomMapAvroTranslator;
import com.github.fge.avro.translators.CustomRecordAvroTranslator;
import com.github.fge.avro.translators.CustomSimpleTranslator;
import com.github.fge.avro.translators.CustomUnionAvroTranslator;
import org.apache.avro.Schema;

public class AvroTranslatorUtil {
    private AvroTranslatorUtil() {
    }

    public static AvroTranslator selectTranslator(Schema.Type avroType) {
        AvroTranslator translator;
        switch (avroType) {
            case RECORD: {
                translator = CustomRecordAvroTranslator.getInstance();
                break;
            }
            case UNION: {
                translator = CustomUnionAvroTranslator.getInstance();
                break;
            }
            case ARRAY: {
                translator = CustomArrayAvroTranslator.getInstance();
                break;
            }
            case MAP: {
                translator = CustomMapAvroTranslator.getInstance();
                break;
            }
            case LONG: {
                translator = CustomLongAvroTranslator.getInstance();
                break;
            }
            case STRING: {
                translator = CustomSimpleTranslator.STRING_INSTANCE;
                break;
            }
            case BOOLEAN: {
                translator = CustomSimpleTranslator.BOOLEAN_INSTANCE;
                break;
            }
            case NULL: {
                translator = CustomSimpleTranslator.NULL_INSTANCE;
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                translator = CustomSimpleTranslator.NUMBER_INSTANCE;
                break;
            }
            case FIXED: {
                translator = CustomFixedTranslator.getInstance();
                break;
            }
            case INT: {
                translator = CustomIntTranslator.getInstance();
                break;
            }
            case BYTES: {
                translator = CustomByteTranslator.getInstance();
                break;
            }
            default: {
                translator = AvroTranslators.getTranslator(avroType);
            }
        }
        return translator;
    }
}

