/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.avro.translators;

import com.github.fge.avro.translators.ArrayTranslator;
import com.github.fge.avro.translators.AvroTranslator;
import com.github.fge.avro.translators.ByteTranslator;
import com.github.fge.avro.translators.EnumTranslator;
import com.github.fge.avro.translators.FixedTranslator;
import com.github.fge.avro.translators.IntTranslator;
import com.github.fge.avro.translators.LongTranslator;
import com.github.fge.avro.translators.MapTranslator;
import com.github.fge.avro.translators.RecordTranslator;
import com.github.fge.avro.translators.SimpleTypeTranslator;
import com.github.fge.avro.translators.UnionTranslator;
import com.github.fge.jackson.NodeType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.avro.Schema;

public final class AvroTranslators {
    private static final Map<Schema.Type, AvroTranslator> TRANSLATORS;

    private AvroTranslators() {
    }

    public static AvroTranslator getTranslator(Schema.Type avroType) {
        return TRANSLATORS.get(avroType);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Schema.Type avroType = Schema.Type.NULL;
        AvroTranslator translator = new SimpleTypeTranslator(NodeType.NULL);
        builder.put((Object)avroType, (Object)translator);
        avroType = Schema.Type.BOOLEAN;
        translator = new SimpleTypeTranslator(NodeType.BOOLEAN);
        builder.put((Object)avroType, (Object)translator);
        avroType = Schema.Type.STRING;
        translator = new SimpleTypeTranslator(NodeType.STRING);
        builder.put((Object)avroType, (Object)translator);
        avroType = Schema.Type.BYTES;
        translator = ByteTranslator.getInstance();
        builder.put((Object)avroType, (Object)translator);
        avroType = Schema.Type.INT;
        translator = IntTranslator.getInstance();
        builder.put((Object)avroType, (Object)translator);
        avroType = Schema.Type.LONG;
        translator = LongTranslator.getInstance();
        builder.put((Object)avroType, (Object)translator);
        avroType = Schema.Type.FLOAT;
        translator = new SimpleTypeTranslator(NodeType.NUMBER);
        builder.put((Object)avroType, (Object)translator);
        avroType = Schema.Type.DOUBLE;
        builder.put((Object)avroType, (Object)translator);
        avroType = Schema.Type.MAP;
        translator = MapTranslator.getInstance();
        builder.put((Object)avroType, (Object)translator);
        avroType = Schema.Type.FIXED;
        translator = FixedTranslator.getInstance();
        builder.put((Object)avroType, (Object)translator);
        avroType = Schema.Type.ENUM;
        translator = EnumTranslator.getInstance();
        builder.put((Object)avroType, (Object)translator);
        avroType = Schema.Type.ARRAY;
        translator = ArrayTranslator.getInstance();
        builder.put((Object)avroType, (Object)translator);
        avroType = Schema.Type.UNION;
        translator = UnionTranslator.getInstance();
        builder.put((Object)avroType, (Object)translator);
        avroType = Schema.Type.RECORD;
        translator = RecordTranslator.getInstance();
        builder.put((Object)avroType, (Object)translator);
        TRANSLATORS = builder.build();
    }
}

