/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.avro.translators;

import com.github.fge.avro.MutableTree;
import com.github.fge.avro.translators.AvroTranslator;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.avro.Schema;

public class CustomFixedTranslator
extends AvroTranslator {
    private static final String BYTES_PATTERN = "^[\u0000-\u00ff]*$";
    private static final AvroTranslator INSTANCE = new CustomFixedTranslator();

    public static AvroTranslator getInstance() {
        return INSTANCE;
    }

    @Override
    public final void translate(Schema avroSchema, MutableTree jsonSchema, ProcessingReport report) throws ProcessingException {
        JsonPointer pwd = jsonSchema.getPointer();
        String avroName = avroSchema.getName();
        JsonPointer ptr = JsonPointer.of((Object)"definitions", (Object[])new Object[]{avroName});
        if (!jsonSchema.hasDefinition(avroName)) {
            jsonSchema.setPointer(ptr);
            this.doTranslate(avroSchema, jsonSchema, report);
            jsonSchema.setPointer(pwd);
        }
        jsonSchema.getCurrentNode().put("$ref", CustomFixedTranslator.createRef(ptr));
    }

    private static String createRef(JsonPointer pointer) {
        try {
            return new URI(null, null, pointer.toString()).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private void doTranslate(Schema avroSchema, MutableTree jsonSchema, ProcessingReport report) {
        int size = avroSchema.getFixedSize();
        jsonSchema.setType(NodeType.STRING);
        if (avroSchema.getDoc() != null) {
            jsonSchema.getCurrentNode().put("description", avroSchema.getDoc());
        }
        jsonSchema.getCurrentNode().put("pattern", BYTES_PATTERN).put("minLength", size).put("maxLength", size);
    }
}

