/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.avro.translators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.avro.MutableTree;
import com.github.fge.avro.translators.AvroTranslator;
import com.github.fge.avro.translators.NamedAvroTypeTranslator;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import org.apache.avro.Schema;

final class EnumTranslator
extends NamedAvroTypeTranslator {
    private static final AvroTranslator INSTANCE = new EnumTranslator();

    private EnumTranslator() {
        super(Schema.Type.ENUM);
    }

    public static AvroTranslator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void doTranslate(Schema avroSchema, MutableTree jsonSchema, ProcessingReport report) {
        if (avroSchema.getDoc() != null) {
            jsonSchema.getCurrentNode().put("description", avroSchema.getDoc());
        }
        ArrayNode enumValues = FACTORY.arrayNode();
        for (String symbol : avroSchema.getEnumSymbols()) {
            enumValues.add(symbol);
        }
        jsonSchema.getCurrentNode().put("enum", (JsonNode)enumValues);
    }
}

