/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.avro.translators;

import com.github.fge.avro.MutableTree;
import com.github.fge.avro.translators.AvroTranslator;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.avro.Schema;

abstract class NamedAvroTypeTranslator
extends AvroTranslator {
    protected final String typeName;

    protected NamedAvroTypeTranslator(Schema.Type type) {
        this.typeName = type.toString().toLowerCase();
    }

    @Override
    public final void translate(Schema avroSchema, MutableTree jsonSchema, ProcessingReport report) throws ProcessingException {
        JsonPointer pwd = jsonSchema.getPointer();
        String avroName = avroSchema.getFullName();
        String fullName = this.typeName + ':' + avroName;
        JsonPointer ptr = JsonPointer.of((Object)"definitions", (Object[])new Object[]{fullName});
        if (!jsonSchema.hasDefinition(fullName)) {
            jsonSchema.setPointer(ptr);
            this.doTranslate(avroSchema, jsonSchema, report);
            jsonSchema.setPointer(pwd);
        }
        jsonSchema.getCurrentNode().put("$ref", NamedAvroTypeTranslator.createRef(ptr));
    }

    protected abstract void doTranslate(Schema var1, MutableTree var2, ProcessingReport var3) throws ProcessingException;

    private static String createRef(JsonPointer pointer) {
        try {
            return new URI(null, null, pointer.toString()).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("How did I get there??", e);
        }
    }
}

