/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.avro.translators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.avro.MutableTree;
import com.github.fge.avro.translators.AvroTranslator;
import com.github.fge.avro.translators.AvroTranslators;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import java.util.List;
import org.apache.avro.Schema;

final class UnionTranslator
extends AvroTranslator {
    private static final AvroTranslator INSTANCE = new UnionTranslator();

    private UnionTranslator() {
    }

    public static AvroTranslator getInstance() {
        return INSTANCE;
    }

    @Override
    public void translate(Schema avroSchema, MutableTree jsonSchema, ProcessingReport report) throws ProcessingException {
        JsonPointer pwd = jsonSchema.getPointer();
        ArrayNode schemas = FACTORY.arrayNode();
        jsonSchema.getCurrentNode().put("oneOf", (JsonNode)schemas);
        List types = avroSchema.getTypes();
        int size = types.size();
        for (int index = 0; index < size; ++index) {
            Schema schema = (Schema)types.get(index);
            Schema.Type type = schema.getType();
            AvroTranslator translator = AvroTranslators.getTranslator(type);
            JsonPointer ptr = JsonPointer.of((Object)"oneOf", (Object[])new Object[]{index});
            schemas.add((JsonNode)FACTORY.objectNode());
            jsonSchema.setPointer(pwd.append(ptr));
            translator.translate(schema, jsonSchema, report);
            jsonSchema.setPointer(pwd);
        }
    }
}

