/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema2avro.predicates;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.library.DraftV4Library;
import com.github.fge.jsonschema.processors.validation.ArraySchemaDigester;
import com.github.fge.jsonschema.processors.validation.ObjectSchemaDigester;
import com.github.fge.jsonschema2avro.AvroPayload;
import com.google.common.base.CharMatcher;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class AvroPredicates {
    private static final Set<String> KNOWN_KEYWORDS;
    private static final CharMatcher NAME_CHAR;
    private static final CharMatcher DIGIT;

    private AvroPredicates() {
    }

    public static Predicate<AvroPayload> simpleType() {
        return new Predicate<AvroPayload>(){

            public boolean apply(AvroPayload input) {
                JsonNode node = AvroPredicates.schemaNode(input);
                NodeType type = AvroPredicates.getType(node);
                if (type == null) {
                    return false;
                }
                return type != NodeType.ARRAY && type != NodeType.OBJECT;
            }
        };
    }

    public static Predicate<AvroPayload> array() {
        return new Predicate<AvroPayload>(){

            public boolean apply(AvroPayload input) {
                JsonNode node = AvroPredicates.schemaNode(input);
                NodeType type = AvroPredicates.getType(node);
                if (NodeType.ARRAY != type) {
                    return false;
                }
                JsonNode digest = ArraySchemaDigester.getInstance().digest(node);
                return digest.get("hasItems").booleanValue() ? !digest.get("itemsIsArray").booleanValue() : digest.get("hasAdditional").booleanValue();
            }
        };
    }

    public static Predicate<AvroPayload> map() {
        return new Predicate<AvroPayload>(){

            public boolean apply(AvroPayload input) {
                JsonNode node = AvroPredicates.schemaNode(input);
                NodeType type = AvroPredicates.getType(node);
                if (NodeType.OBJECT != type) {
                    return false;
                }
                JsonNode digest = ObjectSchemaDigester.getInstance().digest(node);
                if (!digest.get("hasAdditional").booleanValue()) {
                    return false;
                }
                return digest.get("properties").size() == 0 && digest.get("patternProperties").size() == 0;
            }
        };
    }

    public static Predicate<AvroPayload> isEnum() {
        return new Predicate<AvroPayload>(){

            public boolean apply(AvroPayload input) {
                JsonNode node = AvroPredicates.schemaNode(input);
                HashSet set = Sets.newHashSet((Iterator)node.fieldNames());
                set.retainAll(KNOWN_KEYWORDS);
                if (!set.equals(ImmutableSet.of((Object)"enum"))) {
                    return false;
                }
                for (JsonNode element : node.get("enum")) {
                    if (!element.isTextual()) {
                        return false;
                    }
                    if (AvroPredicates.isValidAvroName(element.textValue())) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Predicate<AvroPayload> record() {
        return new Predicate<AvroPayload>(){

            public boolean apply(AvroPayload input) {
                JsonNode node = AvroPredicates.schemaNode(input);
                NodeType type = AvroPredicates.getType(node);
                if (NodeType.OBJECT != type) {
                    return false;
                }
                if (node.path("additionalProperties").asBoolean(true)) {
                    return false;
                }
                if (node.has("patternProperties")) {
                    return false;
                }
                JsonNode properties = node.path("properties");
                if (!properties.isObject()) {
                    return false;
                }
                for (String s : Sets.newHashSet((Iterator)properties.fieldNames())) {
                    if (AvroPredicates.isValidAvroName(s)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Predicate<AvroPayload> simpleUnion() {
        return new Predicate<AvroPayload>(){

            public boolean apply(AvroPayload input) {
                JsonNode node = AvroPredicates.schemaNode(input);
                HashSet members = Sets.newHashSet((Iterator)node.fieldNames());
                members.retainAll(KNOWN_KEYWORDS);
                return members.equals(ImmutableSet.of((Object)"anyOf")) || members.equals(ImmutableSet.of((Object)"oneOf"));
            }
        };
    }

    public static Predicate<AvroPayload> typeUnion() {
        return new Predicate<AvroPayload>(){

            public boolean apply(AvroPayload input) {
                return AvroPredicates.schemaNode(input).path("type").isArray();
            }
        };
    }

    private static JsonNode schemaNode(AvroPayload payload) {
        return payload.getTree().getNode();
    }

    private static NodeType getType(JsonNode node) {
        JsonNode typeNode = node.path("type");
        return typeNode.isTextual() ? NodeType.fromName((String)typeNode.textValue()) : null;
    }

    private static boolean isValidAvroName(String s) {
        if (s.isEmpty()) {
            return false;
        }
        if (!NAME_CHAR.matchesAllOf((CharSequence)s)) {
            return false;
        }
        return !DIGIT.matches(s.charAt(0));
    }

    static {
        CharMatcher letterOrUnderscore = CharMatcher.is((char)'_').or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'A', (char)'Z'));
        CharMatcher digit = CharMatcher.inRange((char)'0', (char)'9');
        NAME_CHAR = letterOrUnderscore.or(digit).precomputed();
        DIGIT = digit.precomputed();
        KNOWN_KEYWORDS = ImmutableSet.copyOf(DraftV4Library.get().getDigesters().entries().keySet());
    }
}

