/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema2avro.writers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.util.AsJson;
import com.github.fge.jsonschema.core.util.ValueHolder;
import com.github.fge.jsonschema2avro.AvroWriterProcessor;
import com.github.fge.jsonschema2avro.writers.AvroWriter;
import org.apache.avro.Schema;

public final class ArrayWriter
extends AvroWriter {
    private static final AvroWriter INSTANCE = new ArrayWriter();

    private ArrayWriter() {
    }

    public static AvroWriter getInstance() {
        return INSTANCE;
    }

    @Override
    protected Schema generate(AvroWriterProcessor writer, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = tree.getNode();
        JsonPointer ptr = node.has("items") ? JsonPointer.of((Object)"items", (Object[])new Object[0]) : JsonPointer.of((Object)"additionalItems", (Object[])new Object[0]);
        SchemaTree subTree = tree.append(ptr);
        ValueHolder input = ValueHolder.hold((String)"schema", (AsJson)subTree);
        Schema itemsSchema = (Schema)writer.process(report, (ValueHolder<SchemaTree>)input).getValue();
        return Schema.createArray((Schema)itemsSchema);
    }
}

