/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema2avro.writers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema2avro.AvroWriterProcessor;
import com.github.fge.jsonschema2avro.writers.AvroWriter;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.avro.Schema;

public final class SimpleTypeWriter
extends AvroWriter {
    private static final Map<NodeType, Schema.Type> TYPEMAP = ImmutableMap.builder().put((Object)NodeType.BOOLEAN, (Object)Schema.Type.BOOLEAN).put((Object)NodeType.NULL, (Object)Schema.Type.NULL).put((Object)NodeType.STRING, (Object)Schema.Type.STRING).put((Object)NodeType.INTEGER, (Object)Schema.Type.LONG).put((Object)NodeType.NUMBER, (Object)Schema.Type.DOUBLE).build();
    private static final AvroWriter INSTANCE = new SimpleTypeWriter();

    private SimpleTypeWriter() {
    }

    public static AvroWriter getInstance() {
        return INSTANCE;
    }

    @Override
    protected Schema generate(AvroWriterProcessor writer, ProcessingReport report, SchemaTree tree) {
        JsonNode node = tree.getNode();
        NodeType type = NodeType.fromName((String)node.get("type").textValue());
        return Schema.create((Schema.Type)TYPEMAP.get(type));
    }
}

