/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.avro;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.avro.IllegalAvroSchemaException;
import com.github.fge.avro.MutableTree;
import com.github.fge.avro.translators.AvroTranslatorUtil;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.RawProcessor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.CanonicalSchemaTree;
import com.github.fge.jsonschema.core.tree.JsonTree;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;

public class CustomAvro2JsonSchemaProcessor
extends RawProcessor<JsonTree, SchemaTree> {
    public CustomAvro2JsonSchemaProcessor() {
        super("avroSchema", "schema");
    }

    public SchemaTree rawProcess(ProcessingReport report, JsonTree input) throws ProcessingException {
        Schema avroSchema;
        JsonNode node = input.getBaseNode();
        try {
            String s = node.toString();
            avroSchema = new Schema.Parser().parse(s);
        }
        catch (AvroRuntimeException e) {
            throw new IllegalAvroSchemaException(e);
        }
        MutableTree tree = new MutableTree();
        Schema.Type avroType = avroSchema.getType();
        AvroTranslatorUtil.selectTranslator(avroType).translate(avroSchema, tree, report);
        return new CanonicalSchemaTree((JsonNode)tree.getBaseNode());
    }
}

