/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.avro.translators;

import com.github.fge.avro.MutableTree;
import com.github.fge.avro.translators.AvroTranslator;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import org.apache.avro.Schema;

public class CustomIntTranslator
extends AvroTranslator {
    private static final AvroTranslator INSTANCE = new CustomIntTranslator();

    public static AvroTranslator getInstance() {
        return INSTANCE;
    }

    @Override
    public void translate(Schema avroSchema, MutableTree jsonSchema, ProcessingReport report) throws ProcessingException {
        jsonSchema.setType(NodeType.INTEGER);
        if (avroSchema.getDoc() != null) {
            jsonSchema.getCurrentNode().put("description", avroSchema.getDoc());
        }
        jsonSchema.getCurrentNode().put("minimum", Integer.MIN_VALUE).put("maximum", Integer.MAX_VALUE);
    }
}

