/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema2avro.writers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema2avro.AvroWriterProcessor;
import com.github.fge.jsonschema2avro.writers.NamedTypeWriter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;

public final class EnumWriter
extends NamedTypeWriter {
    public EnumWriter() {
        super("enum");
    }

    @Override
    protected Schema generate(AvroWriterProcessor writer, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode enumNode = tree.getNode().get("enum");
        ArrayList values = Lists.newArrayList();
        for (JsonNode element : enumNode) {
            values.add(element.textValue());
        }
        return Schema.createEnum((String)this.getName(), null, null, (List)values);
    }
}

