/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema2avro.writers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.util.AsJson;
import com.github.fge.jsonschema.core.util.ValueHolder;
import com.github.fge.jsonschema2avro.AvroWriterProcessor;
import com.github.fge.jsonschema2avro.writers.AvroWriter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;

public final class SimpleUnionWriter
extends AvroWriter {
    private static final AvroWriter INSTANCE = new SimpleUnionWriter();

    private SimpleUnionWriter() {
    }

    public static AvroWriter getInstance() {
        return INSTANCE;
    }

    @Override
    protected Schema generate(AvroWriterProcessor writer, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = tree.getNode();
        String keyword = node.has("oneOf") ? "oneOf" : "anyOf";
        int size = node.get(keyword).size();
        ArrayList schemas = Lists.newArrayList();
        for (int index = 0; index < size; ++index) {
            JsonPointer ptr = JsonPointer.of((Object)keyword, (Object[])new Object[]{index});
            ValueHolder holder = ValueHolder.hold((String)"schema", (AsJson)tree.append(ptr));
            Schema subSchema = (Schema)writer.process(report, (ValueHolder<SchemaTree>)holder).getValue();
            if (subSchema.getType() == Schema.Type.UNION) {
                throw new ProcessingException("union within union is illegal");
            }
            schemas.add(subSchema);
        }
        return Schema.createUnion((List)schemas);
    }
}

