/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.avro;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.util.AsJson;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MutableTree
implements AsJson {
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    private final ObjectNode baseNode = FACTORY.objectNode();
    private JsonPointer pointer = JsonPointer.empty();
    private ObjectNode currentNode = this.baseNode;

    public void setType(NodeType type) {
        this.currentNode.put("type", type.toString());
    }

    public ObjectNode getBaseNode() {
        return this.baseNode;
    }

    public ObjectNode getCurrentNode() {
        return this.currentNode;
    }

    public JsonPointer getPointer() {
        return this.pointer;
    }

    public void setPointer(JsonPointer pointer) {
        this.pointer = pointer;
        this.currentNode = (ObjectNode)pointer.get((TreeNode)this.baseNode);
    }

    public boolean hasDefinition(String name) {
        ObjectNode definitions;
        boolean ret = true;
        if (!this.baseNode.has("definitions")) {
            ret = false;
            this.baseNode.put("definitions", (JsonNode)FACTORY.objectNode());
        }
        if (!(definitions = (ObjectNode)this.baseNode.get("definitions")).has(name)) {
            ret = false;
            definitions.put(name, (JsonNode)FACTORY.objectNode());
        }
        return ret;
    }

    public JsonNode asJson() {
        return FACTORY.objectNode().put("pointer", this.pointer.toString());
    }
}

