/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.avro.translators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.avro.MutableTree;
import com.github.fge.avro.translators.AvroTranslator;
import com.github.fge.avro.translators.AvroTranslatorUtil;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.util.internal.JacksonUtils;

public class CustomRecordAvroTranslator
extends AvroTranslator {
    private static final ObjectMapper OLD_MAPPER = new ObjectMapper();
    private static final AvroTranslator INSTANCE = new CustomRecordAvroTranslator();

    public static AvroTranslator getInstance() {
        return INSTANCE;
    }

    @Override
    public final void translate(Schema avroSchema, MutableTree jsonSchema, ProcessingReport report) throws ProcessingException {
        JsonPointer pwd = jsonSchema.getPointer();
        String avroName = avroSchema.getName();
        JsonPointer ptr = JsonPointer.of((Object)"definitions", (Object[])new Object[]{avroName});
        if (!jsonSchema.hasDefinition(avroName)) {
            jsonSchema.setPointer(ptr);
            this.doTranslate(avroSchema, jsonSchema, report);
            jsonSchema.setPointer(pwd);
        }
        jsonSchema.getCurrentNode().put("$ref", CustomRecordAvroTranslator.createRef(ptr));
    }

    private static String createRef(JsonPointer pointer) {
        try {
            return new URI(null, null, pointer.toString()).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void doTranslate(Schema avroSchema, MutableTree jsonSchema, ProcessingReport report) throws ProcessingException {
        List fields = avroSchema.getFields();
        if (fields.isEmpty()) {
            ArrayNode node = FACTORY.arrayNode();
            node.add((JsonNode)FACTORY.objectNode());
            return;
        }
        JsonPointer pwd = jsonSchema.getPointer();
        ObjectNode root = jsonSchema.getCurrentNode();
        if (avroSchema.getDoc() != null) {
            root.put("description", avroSchema.getDoc());
        }
        jsonSchema.setType(NodeType.OBJECT);
        ArrayNode required = FACTORY.arrayNode();
        root.put("additionalProperties", false);
        ObjectNode properties = FACTORY.objectNode();
        root.set("properties", (JsonNode)properties);
        for (Schema.Field field : fields) {
            String fieldName = field.name();
            Schema fieldSchema = field.schema();
            Schema.Type fieldType = fieldSchema.getType();
            AvroTranslator translator = AvroTranslatorUtil.selectTranslator(fieldType);
            JsonPointer ptr = JsonPointer.of((Object)"properties", (Object[])new Object[]{fieldName});
            ObjectNode propertyNode = FACTORY.objectNode();
            properties.set(fieldName, (JsonNode)propertyNode);
            CustomRecordAvroTranslator.injectDefault(propertyNode, field);
            if (!field.hasDefaultValue() || !(propertyNode.get("default") instanceof NullNode)) {
                required.add(fieldName);
                if (root.get("required") == null) {
                    root.set("required", (JsonNode)required);
                }
            }
            jsonSchema.setPointer(pwd.append(ptr));
            if (field.doc() != null) {
                jsonSchema.getCurrentNode().put("description", field.doc());
            }
            translator.translate(fieldSchema, jsonSchema, report);
            jsonSchema.setPointer(pwd);
        }
    }

    private static void injectDefault(ObjectNode propertyNode, Schema.Field field) {
        JsonNode value = JacksonUtils.toJsonNode((Object)field.defaultVal());
        if (value == null) {
            return;
        }
        try {
            String s = OLD_MAPPER.writeValueAsString((Object)value);
            propertyNode.set("default", JsonLoader.fromString((String)s));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

