/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.avro.translators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.avro.MutableTree;
import com.github.fge.avro.translators.AvroTranslator;
import com.github.fge.avro.translators.AvroTranslatorUtil;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;

public class CustomUnionAvroTranslator
extends AvroTranslator {
    private static final AvroTranslator INSTANCE = new CustomUnionAvroTranslator();

    public static AvroTranslator getInstance() {
        return INSTANCE;
    }

    @Override
    public void translate(Schema avroSchema, MutableTree jsonSchema, ProcessingReport report) throws ProcessingException {
        JsonPointer pwd = jsonSchema.getPointer();
        List types = avroSchema.getTypes().stream().filter(schemaElement -> !Schema.Type.NULL.equals((Object)schemaElement.getType())).collect(Collectors.toList());
        int size = types.size();
        if (size == 1) {
            AvroTranslatorUtil.selectTranslator(((Schema)types.get(0)).getType()).translate((Schema)types.get(0), jsonSchema, report);
            return;
        }
        if (size == 0) {
            return;
        }
        for (Schema schema : types) {
            if (!Schema.Type.STRING.equals((Object)schema.getType())) continue;
            AvroTranslatorUtil.selectTranslator(schema.getType()).translate(schema, jsonSchema, report);
            return;
        }
        ArrayNode schemas = FACTORY.arrayNode();
        jsonSchema.getCurrentNode().set("oneOf", (JsonNode)schemas);
        for (int index = 0; index < size; ++index) {
            Schema schema;
            schema = (Schema)types.get(index);
            Schema.Type type = schema.getType();
            AvroTranslator translator = AvroTranslatorUtil.selectTranslator(type);
            JsonPointer ptr = JsonPointer.of((Object)"oneOf", (Object[])new Object[]{index});
            schemas.add((JsonNode)FACTORY.objectNode());
            jsonSchema.setPointer(pwd.append(ptr));
            translator.translate(schema, jsonSchema, report);
            jsonSchema.setPointer(pwd);
        }
    }
}

