/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema2avro.writers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.CanonicalSchemaTree;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.util.AsJson;
import com.github.fge.jsonschema.core.util.ValueHolder;
import com.github.fge.jsonschema2avro.AvroWriterProcessor;
import com.github.fge.jsonschema2avro.writers.AvroWriter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;

public final class TypeUnionWriter
extends AvroWriter {
    private static final AvroWriter INSTANCE = new TypeUnionWriter();

    private TypeUnionWriter() {
    }

    public static AvroWriter getInstance() {
        return INSTANCE;
    }

    @Override
    protected Schema generate(AvroWriterProcessor writer, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = tree.getNode();
        ArrayList schemas = Lists.newArrayList();
        for (ValueHolder<SchemaTree> holder : TypeUnionWriter.expand(node)) {
            schemas.add((Schema)writer.process(report, holder).getValue());
        }
        return Schema.createUnion((List)schemas);
    }

    private static List<ValueHolder<SchemaTree>> expand(JsonNode node) {
        ObjectNode common = (ObjectNode)node.deepCopy();
        ArrayNode typeNode = (ArrayNode)common.remove("type");
        ArrayList ret = Lists.newArrayList();
        for (JsonNode element : typeNode) {
            ObjectNode schema = common.deepCopy();
            schema.put("type", element);
            CanonicalSchemaTree tree = new CanonicalSchemaTree((JsonNode)schema);
            ret.add(ValueHolder.hold((String)"schema", (AsJson)tree));
        }
        return ret;
    }
}

