/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.processing;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.avro.CustomAvro2JsonSchemaProcessor;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.JsonNodeReader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.SyntaxProcessor;
import com.github.fge.jsonschema.core.messages.JsonSchemaSyntaxMessageBundle;
import com.github.fge.jsonschema.core.processing.ProcessingResult;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.processing.ProcessorChain;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.MessageProvider;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.JsonTree;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.tree.SimpleJsonTree;
import com.github.fge.jsonschema.core.util.AsJson;
import com.github.fge.jsonschema.core.util.ValueHolder;
import com.github.fge.jsonschema.library.DraftV4Library;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class ProcessingUtil {
    private static final String LINE = "line";
    private static final String OFFSET = "offset";
    private static final String MESSAGE = "message";
    public static final String INPUT = "input";
    public static final String INVALID_INPUT = "input-invalid";
    public static final JsonNodeFactory NODE_FACTORY = JacksonUtils.nodeFactory();
    public static final JsonNodeReader nodeReader = new JsonNodeReader();
    public static final CustomAvro2JsonSchemaProcessor _customAvro2JsonSchemaProcessor = new CustomAvro2JsonSchemaProcessor();
    public static final MessageBundle bundle = MessageBundles.getBundle(JsonSchemaSyntaxMessageBundle.class);
    public static final SyntaxProcessor syntax = new SyntaxProcessor(bundle, DraftV4Library.get().getSyntaxCheckers());
    public static final Processor<ValueHolder<JsonTree>, ValueHolder<SchemaTree>> processor = ProcessorChain.startWith((Processor)_customAvro2JsonSchemaProcessor).chainWith((Processor)syntax).getProcessor();

    public static JsonNode buildResult(String input) throws IOException, ProcessingException {
        ObjectNode ret = NODE_FACTORY.objectNode();
        boolean invalidSchema = ProcessingUtil.fillWithData(ret, input, nodeReader);
        JsonNode schemaNode = ret.remove(INPUT);
        if (invalidSchema) {
            return ret;
        }
        ListProcessingReport report = new ListProcessingReport();
        SimpleJsonTree tree = new SimpleJsonTree(schemaNode);
        ValueHolder holder = ValueHolder.hold((AsJson)tree);
        ProcessingResult result = ProcessingResult.uncheckedResult(processor, (ProcessingReport)report, (MessageProvider)holder);
        boolean success = result.isSuccess();
        if (!success) {
            throw new IllegalArgumentException("JSON Schema processing error, please validate the following Avro schema: " + input);
        }
        return success ? ((SchemaTree)((ValueHolder)result.getResult()).getValue()).getBaseNode() : ProcessingUtil.buildReport(result.getReport());
    }

    public static boolean fillWithData(ObjectNode node, String raw, JsonNodeReader nodeReader) throws IOException {
        try {
            node.set(INPUT, nodeReader.fromReader((Reader)new StringReader(raw)));
            return false;
        }
        catch (JsonProcessingException e) {
            node.set(INVALID_INPUT, ProcessingUtil.build(e, raw.contains("\r\n")));
            return true;
        }
    }

    public static JsonNode build(JsonProcessingException e, boolean crlf) {
        JsonLocation location = e.getLocation();
        ObjectNode ret = JsonNodeFactory.instance.objectNode();
        int lineNr = location.getLineNr();
        int offset = (int)location.getCharOffset();
        if (crlf) {
            offset = offset - lineNr + 1;
        }
        ret.put(LINE, lineNr);
        ret.put(OFFSET, offset);
        ret.put(MESSAGE, e.getOriginalMessage());
        return ret;
    }

    public static JsonNode buildReport(ProcessingReport report) {
        ArrayNode ret = NODE_FACTORY.arrayNode();
        for (ProcessingMessage message : report) {
            ret.add(message.asJson());
        }
        return ret;
    }
}

