/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.client.http;

import com.linkedin.r2.netty.handler.common.CancelTimeoutHandler;
import com.linkedin.r2.netty.handler.common.ChannelLifecycleHandler;
import com.linkedin.r2.netty.handler.common.ClientEntityStreamHandler;
import com.linkedin.r2.netty.handler.common.SchemeHandler;
import com.linkedin.r2.netty.handler.common.SessionResumptionSslHandler;
import com.linkedin.r2.netty.handler.http.HttpMessageDecoders;
import com.linkedin.r2.netty.handler.http.HttpMessageEncoders;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpScheme;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

class HttpChannelInitializer
extends ChannelInitializer<NioSocketChannel> {
    private static final boolean RECYCLE_CHANNEL = true;
    private final SSLContext _sslContext;
    private final SSLParameters _sslParameters;
    private final int _maxInitialLineLength;
    private final int _maxHeaderSize;
    private final int _maxChunkSize;
    private final int _sslHandShakeTimeout;
    private final long _maxContentLength;
    private final boolean _ssl;
    private final boolean _enableSSLSessionResumption;

    HttpChannelInitializer(SSLContext sslContext, SSLParameters sslParameters, int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, long maxContentLength, boolean enableSSLSessionResumption, int sslHandShakeTimeout) {
        this._sslContext = sslContext;
        this._sslParameters = sslParameters;
        this._maxInitialLineLength = maxInitialLineLength;
        this._maxHeaderSize = maxHeaderSize;
        this._maxChunkSize = maxChunkSize;
        this._maxContentLength = maxContentLength;
        this._sslHandShakeTimeout = sslHandShakeTimeout;
        this._ssl = this._sslContext != null && this._sslParameters != null;
        this._enableSSLSessionResumption = enableSSLSessionResumption;
    }

    protected void initChannel(NioSocketChannel channel) {
        if (this._ssl) {
            channel.pipeline().addLast("SessionResumptionSslHandler", (ChannelHandler)new SessionResumptionSslHandler(this._sslContext, this._sslParameters, this._enableSSLSessionResumption, this._sslHandShakeTimeout));
        }
        channel.pipeline().addLast("codec", (ChannelHandler)new HttpClientCodec(this._maxInitialLineLength, this._maxHeaderSize, this._maxChunkSize));
        channel.pipeline().addLast("outboundRestRequestEncoder", (ChannelHandler)HttpMessageEncoders.newRestRequestEncoder());
        channel.pipeline().addLast("outboundStreamDataEncoder", (ChannelHandler)HttpMessageEncoders.newDataEncoder());
        channel.pipeline().addLast("outboundStreamRequestEncoder", (ChannelHandler)HttpMessageEncoders.newStreamRequestEncoder());
        channel.pipeline().addLast("inboundDataDecoder", (ChannelHandler)HttpMessageDecoders.newDataDecoder());
        channel.pipeline().addLast("inboundRequestDecoder", (ChannelHandler)HttpMessageDecoders.newResponseDecoder());
        channel.pipeline().addLast("schemeHandler", (ChannelHandler)new SchemeHandler(this._ssl ? HttpScheme.HTTPS.toString() : HttpScheme.HTTP.toString()));
        channel.pipeline().addLast("streamDuplexHandler", (ChannelHandler)new ClientEntityStreamHandler(this._maxContentLength));
        channel.pipeline().addLast("timeoutHandler", (ChannelHandler)new CancelTimeoutHandler());
        channel.pipeline().addLast("channelPoolHandler", (ChannelHandler)new ChannelLifecycleHandler(true));
    }
}

