/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.client.http;

import com.linkedin.common.stats.LongTracker;
import com.linkedin.common.stats.NoopLongTracker;
import com.linkedin.r2.netty.client.http.HttpChannelInitializer;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.AsyncPoolImpl;
import com.linkedin.r2.transport.http.client.ExponentialBackOffRateLimiter;
import com.linkedin.r2.transport.http.client.RateLimiter;
import com.linkedin.r2.transport.http.client.common.ChannelPoolFactory;
import com.linkedin.r2.transport.http.client.common.ChannelPoolLifecycle;
import com.linkedin.util.clock.Clock;
import com.linkedin.util.clock.SystemClock;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.SocketAddress;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class HttpChannelPoolFactory
implements ChannelPoolFactory {
    private final long _idleTimeout;
    private final int _maxPoolWaiterSize;
    private final int _maxPoolSize;
    private final int _minPoolSize;
    private final int _maxConcurrentConnectionInitializations;
    private final boolean _tcpNoDelay;
    private final Bootstrap _bootstrap;
    private final ChannelGroup _allChannels;
    private final ScheduledExecutorService _scheduler;
    private final AsyncPoolImpl.Strategy _strategy;
    private int _channelPoolWaiterTimeout;

    public HttpChannelPoolFactory(ScheduledExecutorService scheduler, EventLoopGroup eventLoopGroup, ChannelGroup channelGroup, AsyncPoolImpl.Strategy strategy, SSLContext sslContext, SSLParameters sslParameters, int maxPoolSize, int minPoolSize, int maxPoolWaiterSize, int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, int maxConcurrentConnectionInitializations, long idleTimeout, long maxContentLength, boolean tcpNoDelay, boolean enableSSLSessionResumption, int channelPoolWaiterTimeout, int connectTimeout, int sslHandShakeTimeout) {
        HttpChannelInitializer initializer = new HttpChannelInitializer(sslContext, sslParameters, maxInitialLineLength, maxHeaderSize, maxChunkSize, maxContentLength, enableSSLSessionResumption, sslHandShakeTimeout);
        this._scheduler = scheduler;
        this._allChannels = channelGroup;
        this._strategy = strategy;
        this._maxPoolSize = maxPoolSize;
        this._minPoolSize = minPoolSize;
        this._maxPoolWaiterSize = maxPoolWaiterSize;
        this._maxConcurrentConnectionInitializations = maxConcurrentConnectionInitializations;
        this._idleTimeout = idleTimeout;
        this._tcpNoDelay = tcpNoDelay;
        this._channelPoolWaiterTimeout = channelPoolWaiterTimeout;
        this._bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout)).handler((ChannelHandler)initializer);
    }

    @Override
    public AsyncPool<Channel> getPool(SocketAddress address) {
        return new AsyncPoolImpl(address.toString(), (AsyncPool.Lifecycle)new ChannelPoolLifecycle(address, this._bootstrap, this._allChannels, this._tcpNoDelay), this._maxPoolSize, this._idleTimeout, (long)this._channelPoolWaiterTimeout, this._scheduler, this._maxPoolWaiterSize, this._strategy, this._minPoolSize, (RateLimiter)new ExponentialBackOffRateLimiter(0L, 5000L, 100L, this._scheduler, this._maxConcurrentConnectionInitializations), (Clock)SystemClock.instance(), (LongTracker)NoopLongTracker.instance());
    }
}

