/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.client.http2;

import com.linkedin.r2.netty.common.NettyChannelAttributes;
import com.linkedin.r2.netty.handler.common.SessionResumptionSslHandler;
import com.linkedin.r2.netty.handler.http2.Http2AlpnHandler;
import com.linkedin.r2.netty.handler.http2.Http2ProtocolUpgradeHandler;
import com.linkedin.r2.netty.handler.http2.UnsupportedHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;

class Http2ChannelInitializer
extends ChannelInitializer<NioSocketChannel> {
    private static final long MAX_INITIAL_STREAM_WINDOW_SIZE = 0x800000L;
    private static final boolean IS_CLIENT = true;
    private final SSLContext _sslContext;
    private final SSLParameters _sslParameters;
    private final int _maxInitialLineLength;
    private final int _maxHeaderSize;
    private final int _maxChunkSize;
    private final int _maxContentLength;
    private final int _sslHandShakeTimeout;
    private final boolean _ssl;
    private final boolean _enableSSLSessionResumption;

    Http2ChannelInitializer(SSLContext sslContext, SSLParameters sslParameters, int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, long maxContentLength, boolean enableSSLSessionResumption, int sslHandShakeTimeout) {
        this._sslContext = sslContext;
        this._sslParameters = sslParameters;
        this._maxInitialLineLength = maxInitialLineLength;
        this._maxHeaderSize = maxHeaderSize;
        this._maxChunkSize = maxChunkSize;
        this._maxContentLength = maxContentLength > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxContentLength;
        this._sslHandShakeTimeout = sslHandShakeTimeout;
        this._ssl = this._sslContext != null && this._sslParameters != null;
        this._enableSSLSessionResumption = enableSSLSessionResumption;
    }

    protected void initChannel(NioSocketChannel channel) throws SSLException {
        if (this._ssl) {
            this.configureSsl(channel);
        } else {
            this.configureClearText(channel);
        }
    }

    private void configureSsl(NioSocketChannel channel) throws SSLException {
        JdkSslContext sslCtx = this.createSslContext();
        ChannelPromise alpnPromise = channel.newPromise();
        channel.attr(NettyChannelAttributes.INITIALIZATION_FUTURE).set((Object)alpnPromise);
        channel.pipeline().addLast("SessionResumptionSslHandler", (ChannelHandler)new SessionResumptionSslHandler((SslContext)sslCtx, this._enableSSLSessionResumption, this._sslHandShakeTimeout));
        channel.pipeline().addLast(new ChannelHandler[]{new Http2AlpnHandler(alpnPromise, this.createHttp2Settings())});
    }

    private JdkSslContext createSslContext() {
        return new JdkSslContext(this._sslContext, true, Arrays.asList(this._sslParameters.getCipherSuites()), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}), this._sslParameters.getNeedClientAuth() ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL);
    }

    private void configureClearText(NioSocketChannel channel) {
        HttpClientCodec sourceCodec = new HttpClientCodec(this._maxInitialLineLength, this._maxHeaderSize, this._maxChunkSize);
        UnsupportedHandler unsupportedHandler = new UnsupportedHandler();
        Http2MultiplexHandler multiplexHandler = new Http2MultiplexHandler((ChannelHandler)unsupportedHandler, (ChannelHandler)unsupportedHandler);
        Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)Http2FrameCodecBuilder.forClient().initialSettings(this.createHttp2Settings()).build(), multiplexHandler);
        ChannelPromise upgradePromise = channel.newPromise();
        channel.attr(NettyChannelAttributes.INITIALIZATION_FUTURE).set((Object)upgradePromise);
        channel.pipeline().addLast(new ChannelHandler[]{sourceCodec});
        channel.pipeline().addLast(new ChannelHandler[]{new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, this._maxContentLength)});
        channel.pipeline().addLast(new ChannelHandler[]{new Http2ProtocolUpgradeHandler(upgradePromise)});
    }

    private Http2Settings createHttp2Settings() {
        Http2Settings settings = new Http2Settings();
        settings.initialWindowSize((int)Math.min(0x800000L, (long)this._maxContentLength));
        settings.maxHeaderListSize((long)this._maxHeaderSize);
        return settings;
    }
}

