/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.client.http2;

import com.linkedin.common.callback.Callback;
import com.linkedin.r2.netty.client.http2.Http2StreamChannelInitializer;
import com.linkedin.r2.netty.common.NettyChannelAttributes;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.ObjectCreationTimeoutException;
import com.linkedin.r2.transport.http.client.PoolStats;
import com.linkedin.r2.transport.http.client.TimeoutCallback;
import com.linkedin.util.clock.Clock;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Http2ChannelLifecycle
implements AsyncPool.Lifecycle<Channel> {
    private static final Logger LOG = LoggerFactory.getLogger(Http2ChannelLifecycle.class);
    public static final int DEFAULT_CHANNEL_CREATION_TIMEOUT_MS = 10000;
    private final SocketAddress _address;
    private final ScheduledExecutorService _scheduler;
    private final Clock _clock;
    private final boolean _ssl;
    private final long _maxContentLength;
    private final long _idleTimeout;
    private final long _channelCreationTimeoutMs;
    private AsyncPool.Lifecycle<Channel> _parentChannelLifecycle;
    private final Object _lock = new Object();
    private final Queue<Callback<Channel>> _waiters = new ArrayDeque<Callback<Channel>>();
    private final ChannelGroup _channelGroup;
    private boolean _bootstrapping = false;
    private Channel _parentChannel = null;
    private long _childChannelCount;
    private long _lastActiveTime;

    Http2ChannelLifecycle(SocketAddress address, ScheduledExecutorService scheduler, Clock clock, ChannelGroup channelGroup, boolean ssl, long maxContentLength, long idleTimeout, AsyncPool.Lifecycle<Channel> parentChannelLifecycle) {
        this._address = address;
        this._scheduler = scheduler;
        this._clock = clock;
        this._channelGroup = channelGroup;
        this._ssl = ssl;
        this._maxContentLength = maxContentLength;
        this._idleTimeout = idleTimeout;
        this._parentChannelLifecycle = parentChannelLifecycle;
        this._childChannelCount = 0L;
        this._channelCreationTimeoutMs = 10000L;
        this._lastActiveTime = this._clock.currentTimeMillis();
        this._scheduler.scheduleAtFixedRate(this::closeParentIfIdle, idleTimeout, idleTimeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Callback<Channel> callback) {
        Channel parentChannel;
        Object object = this._lock;
        synchronized (object) {
            this._lastActiveTime = this._clock.currentTimeMillis();
            parentChannel = this._parentChannel;
        }
        if (!this.isChannelActive(parentChannel)) {
            parentChannel = null;
            object = this._lock;
            synchronized (object) {
                this._childChannelCount = 0L;
            }
        }
        if (parentChannel == null) {
            object = this._lock;
            synchronized (object) {
                this._waiters.add(callback);
                if (this._bootstrapping) {
                    return;
                }
                this._bootstrapping = true;
            }
            this.doBootstrapParentChannel(new Callback<Channel>(){

                public void onError(Throwable e) {
                    Http2ChannelLifecycle.this.notifyWaiters(e);
                }

                public void onSuccess(Channel channel) {
                    Http2ChannelLifecycle.this.doBootstrapWaitersStreamChannel(channel);
                }
            });
        } else {
            this.doBootstrapStreamChannel(parentChannel, callback);
        }
    }

    private boolean isChannelActive(Channel channel) {
        return channel != null && channel.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBootstrapWaitersStreamChannel(Channel channel) {
        ArrayList waiters;
        Iterator iterator = this._lock;
        synchronized (iterator) {
            this._parentChannel = channel;
            this._channelGroup.add((Object)channel);
            waiters = new ArrayList(this._waiters.size());
            IntStream.range(0, this._waiters.size()).forEach(i -> waiters.add(this._waiters.poll()));
            this._bootstrapping = false;
        }
        for (Callback waiter : waiters) {
            this.doBootstrapStreamChannel(channel, (Callback<Channel>)waiter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaiters(Throwable e) {
        ArrayList waiters;
        Iterator iterator = this._lock;
        synchronized (iterator) {
            waiters = new ArrayList(this._waiters.size());
            IntStream.range(0, this._waiters.size()).forEach(i -> waiters.add(this._waiters.poll()));
            this._bootstrapping = false;
        }
        for (Callback waiter : waiters) {
            waiter.onError(e);
        }
    }

    private void doBootstrapParentChannel(final Callback<Channel> callback) {
        this._parentChannelLifecycle.create((Callback)new TimeoutCallback(this._scheduler, this._channelCreationTimeoutMs, TimeUnit.MILLISECONDS, (Callback)new Callback<Channel>(){

            public void onError(Throwable error) {
                callback.onError(error);
                if (error instanceof ObjectCreationTimeoutException) {
                    LOG.error(error.getMessage(), error);
                }
            }

            public void onSuccess(Channel channel) {
                ((ChannelFuture)channel.attr(NettyChannelAttributes.INITIALIZATION_FUTURE).get()).addListener(alpnFuture -> {
                    if (alpnFuture.isSuccess()) {
                        callback.onSuccess((Object)channel);
                    } else {
                        callback.onError(alpnFuture.cause());
                    }
                });
            }
        }, () -> new ObjectCreationTimeoutException("Exceeded creation timeout of " + this._channelCreationTimeoutMs + "ms: for HTTP/2 parent channel, remote=" + this._address)));
    }

    private void doBootstrapStreamChannel(Channel channel, Callback<Channel> callback) {
        Http2StreamChannelBootstrap bootstrap = new Http2StreamChannelBootstrap(channel).handler((ChannelHandler)new Http2StreamChannelInitializer(this._ssl, this._maxContentLength));
        bootstrap.open().addListener(future -> {
            if (future.isSuccess()) {
                Object object = this._lock;
                synchronized (object) {
                    ++this._childChannelCount;
                }
                callback.onSuccess((Object)((Http2StreamChannel)future.get()));
            } else {
                channel.close();
                callback.onError(future.cause());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeParentIfIdle() {
        long childChannelCount;
        long lastActiveTime;
        Channel channel;
        Object object = this._lock;
        synchronized (object) {
            channel = this._parentChannel;
            lastActiveTime = this._lastActiveTime;
            childChannelCount = this._childChannelCount;
        }
        if (this._clock.currentTimeMillis() - lastActiveTime < this._idleTimeout) {
            return;
        }
        if (channel == null || !channel.isOpen()) {
            return;
        }
        if (childChannelCount > 0L) {
            return;
        }
        object = this._lock;
        synchronized (object) {
            this._parentChannel = null;
            this._childChannelCount = 0L;
        }
        LOG.info("Closing parent channel due to idle timeout !");
        channel.close().addListener(future -> {
            if (!future.isSuccess()) {
                LOG.error("Failed to close parent channel after idle timeout, remote={}", (Object)this._address, (Object)future.cause());
            }
        });
    }

    public boolean validateGet(Channel channel) {
        return this._parentChannelLifecycle.validateGet((Object)channel);
    }

    public boolean validatePut(Channel channel) {
        return this._parentChannelLifecycle.validatePut((Object)channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Channel channel, boolean error, Callback<Channel> callback) {
        this._parentChannelLifecycle.destroy((Object)channel, error, callback);
        Object object = this._lock;
        synchronized (object) {
            if (this._childChannelCount > 0L) {
                --this._childChannelCount;
            }
        }
    }

    public PoolStats.LifecycleStats getStats() {
        return this._parentChannelLifecycle.getStats();
    }
}

