/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.client.http2;

import com.linkedin.common.stats.LongTracker;
import com.linkedin.common.stats.NoopLongTracker;
import com.linkedin.r2.netty.client.http2.Http2ChannelInitializer;
import com.linkedin.r2.netty.client.http2.Http2ChannelLifecycle;
import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.AsyncPoolImpl;
import com.linkedin.r2.transport.http.client.NoopRateLimiter;
import com.linkedin.r2.transport.http.client.RateLimiter;
import com.linkedin.r2.transport.http.client.common.ChannelPoolFactory;
import com.linkedin.r2.transport.http.client.common.ChannelPoolLifecycle;
import com.linkedin.util.clock.Clock;
import com.linkedin.util.clock.SystemClock;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.SocketAddress;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class Http2ChannelPoolFactory
implements ChannelPoolFactory {
    private final long _idleTimeout;
    private final long _maxContentLength;
    private final int _maxPoolWaiterSize;
    private final int _maxPoolSize;
    private final int _minPoolSize;
    private final boolean _tcpNoDelay;
    private final boolean _ssl;
    private final Bootstrap _bootstrap;
    private final ChannelGroup _allChannels;
    private final ScheduledExecutorService _scheduler;
    private final AsyncPoolImpl.Strategy _strategy;

    public Http2ChannelPoolFactory(ScheduledExecutorService scheduler, EventLoopGroup eventLoopGroup, ChannelGroup channelGroup, AsyncPoolImpl.Strategy strategy, SSLContext sslContext, SSLParameters sslParameters, int maxPoolSize, int minPoolSize, int maxPoolWaiterSize, int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, long idleTimeout, long maxContentLength, boolean tcpNoDelay, boolean enableSSLSessionResumption, int connectTimeout, int sslHandShakeTimeout) {
        Http2ChannelInitializer initializer = new Http2ChannelInitializer(sslContext, sslParameters, maxInitialLineLength, maxHeaderSize, maxChunkSize, maxContentLength, enableSSLSessionResumption, sslHandShakeTimeout);
        this._scheduler = scheduler;
        this._allChannels = channelGroup;
        this._strategy = strategy;
        this._maxPoolSize = maxPoolSize;
        this._minPoolSize = minPoolSize;
        this._maxPoolWaiterSize = maxPoolWaiterSize;
        this._idleTimeout = idleTimeout;
        this._maxContentLength = maxContentLength;
        this._tcpNoDelay = tcpNoDelay;
        this._bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout)).handler((ChannelHandler)initializer);
        this._ssl = sslContext != null && sslParameters != null;
    }

    @Override
    public AsyncPool<Channel> getPool(SocketAddress address) {
        return new AsyncPoolImpl(address.toString(), (AsyncPool.Lifecycle)new Http2ChannelLifecycle(address, this._scheduler, (Clock)SystemClock.instance(), this._allChannels, this._ssl, this._maxContentLength, this._idleTimeout, new ChannelPoolLifecycle(address, this._bootstrap, this._allChannels, this._tcpNoDelay)), this._maxPoolSize, this._idleTimeout, this._scheduler, this._maxPoolWaiterSize, this._strategy, this._minPoolSize, (RateLimiter)new NoopRateLimiter(), (Clock)SystemClock.instance(), (LongTracker)NoopLongTracker.instance());
    }
}

