/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.client.http2;

import com.linkedin.r2.netty.handler.common.CancelTimeoutHandler;
import com.linkedin.r2.netty.handler.common.ChannelLifecycleHandler;
import com.linkedin.r2.netty.handler.common.ClientEntityStreamHandler;
import com.linkedin.r2.netty.handler.common.SchemeHandler;
import com.linkedin.r2.netty.handler.http2.Http2MessageDecoders;
import com.linkedin.r2.netty.handler.http2.Http2MessageEncoders;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.HttpScheme;

class Http2StreamChannelInitializer
extends ChannelInitializer<Channel> {
    private static final boolean CHANNEL_RECYCLE = false;
    private final boolean _ssl;
    private final long _maxContentLength;

    public Http2StreamChannelInitializer(boolean ssl, long maxContentLength) {
        this._ssl = ssl;
        this._maxContentLength = maxContentLength;
    }

    protected void initChannel(Channel channel) {
        channel.pipeline().addLast("outboundRestRequestEncoder", (ChannelHandler)Http2MessageEncoders.newRestRequestEncoder());
        channel.pipeline().addLast("outboundStreamDataEncoder", (ChannelHandler)Http2MessageEncoders.newDataEncoder());
        channel.pipeline().addLast("outboundStreamRequestEncoder", (ChannelHandler)Http2MessageEncoders.newStreamRequestEncoder());
        channel.pipeline().addLast("inboundDataDecoder", (ChannelHandler)Http2MessageDecoders.newDataDecoder());
        channel.pipeline().addLast("inboundRequestDecoder", (ChannelHandler)Http2MessageDecoders.newResponseDecoder());
        channel.pipeline().addLast("schemeHandler", (ChannelHandler)new SchemeHandler(this._ssl ? HttpScheme.HTTPS.toString() : HttpScheme.HTTP.toString()));
        channel.pipeline().addLast("streamDuplexHandler", (ChannelHandler)new ClientEntityStreamHandler(this._maxContentLength));
        channel.pipeline().addLast("timeoutHandler", (ChannelHandler)new CancelTimeoutHandler());
        channel.pipeline().addLast("channelPoolHandler", (ChannelHandler)new ChannelLifecycleHandler(false));
    }
}

