/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.common;

import io.netty.handler.ssl.SslHandler;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslHandlerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SslHandlerUtil.class);
    public static final String PIPELINE_SSL_HANDLER = "sslHandler";

    public static SslHandler getClientSslHandler(SSLContext sslContext, SSLParameters sslParameters, String host, int port) {
        return SslHandlerUtil.getSslHandler(sslContext, sslParameters, true, host, port);
    }

    public static SslHandler getServerSslHandler(SSLContext sslContext, SSLParameters sslParameters) {
        return SslHandlerUtil.getSslHandler(sslContext, sslParameters, false);
    }

    public static SslHandler getSslHandler(SSLContext sslContext, SSLParameters sslParameters, boolean clientMode) {
        return SslHandlerUtil.getSslHandler(sslContext, sslParameters, clientMode, null, -1);
    }

    private static SslHandler getSslHandler(SSLContext sslContext, SSLParameters sslParameters, boolean clientMode, String host, int port) {
        SSLEngine sslEngine = host == null || port == -1 ? sslContext.createSSLEngine() : sslContext.createSSLEngine(host, port);
        sslEngine.setUseClientMode(clientMode);
        if (sslParameters != null) {
            sslEngine.setSSLParameters(sslParameters);
        }
        return new SslHandler(sslEngine);
    }

    public static void validateSslParameters(SSLContext sslContext, SSLParameters sslParameters) {
        if (sslParameters != null) {
            if (sslContext == null) {
                throw new IllegalArgumentException("SSLParameters passed with no SSLContext");
            }
            SSLParameters supportedSSLParameters = sslContext.getSupportedSSLParameters();
            if (sslParameters.getCipherSuites() != null) {
                SslHandlerUtil.checkContained(supportedSSLParameters.getCipherSuites(), sslParameters.getCipherSuites(), "cipher suite");
            }
            if (sslParameters.getProtocols() != null) {
                SslHandlerUtil.checkContained(supportedSSLParameters.getProtocols(), sslParameters.getProtocols(), "protocol");
            }
        }
    }

    private static void checkContained(String[] containingArray, String[] containedArray, String valueName) {
        HashSet<String> containingSet = new HashSet<String>(Arrays.asList(containingArray));
        HashSet<String> containedSet = new HashSet<String>(Arrays.asList(containedArray));
        boolean changed = containedSet.removeAll(containingSet);
        if (!changed) {
            throw new IllegalArgumentException("None of the requested " + valueName + "s: " + containedSet + " are found in SSLContext");
        }
        if (!containedSet.isEmpty()) {
            for (String paramValue : containedSet) {
                LOG.warn("{} {} requested but not found in SSLContext", (Object)valueName, (Object)paramValue);
            }
        }
    }
}

