/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.common;

import com.linkedin.util.clock.Clock;
import io.netty.channel.Channel;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public class StreamingTimeout {
    public static final String STREAMING_TIMEOUT_MESSAGE = "Exceeded stream idle timeout of %sms";
    private final ScheduledExecutorService _scheduler;
    private final long _streamingTimeout;
    private final Channel _channel;
    private final Clock _clock;
    private final AtomicLong _lastActiveTime;
    private final Object _lock = new Object();
    private ScheduledFuture<?> _future;

    public StreamingTimeout(ScheduledExecutorService scheduler, long streamingTimeout, Channel channel, Clock clock) {
        this._scheduler = scheduler;
        this._streamingTimeout = streamingTimeout;
        this._channel = channel;
        this._clock = clock;
        this._lastActiveTime = new AtomicLong(clock.currentTimeMillis());
        this.scheduleNextIdleTimeout();
    }

    public void refreshLastActiveTime() {
        this._lastActiveTime.getAndSet(this._clock.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this._lock;
        synchronized (object) {
            if (this._future != null) {
                this._future.cancel(false);
            }
        }
    }

    private void raiseTimeoutIfIdle() {
        if (this._clock.currentTimeMillis() - this._lastActiveTime.get() < this._streamingTimeout) {
            this.scheduleNextIdleTimeout();
        } else {
            this._channel.pipeline().fireExceptionCaught((Throwable)new TimeoutException(String.format(STREAMING_TIMEOUT_MESSAGE, this._streamingTimeout)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextIdleTimeout() {
        ScheduledFuture<?> future = this._scheduler.schedule(this::raiseTimeoutIfIdle, this.getNextExecutionTime(), TimeUnit.MILLISECONDS);
        Object object = this._lock;
        synchronized (object) {
            this._future = future;
        }
    }

    private long getNextExecutionTime() {
        long timeElapsed = this._clock.currentTimeMillis() - this._lastActiveTime.get();
        long timeRemaining = this._streamingTimeout - timeElapsed;
        return timeRemaining;
    }
}

