/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.netty.entitystream;

import com.linkedin.data.ByteString;
import com.linkedin.r2.RemoteInvocationException;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;
import com.linkedin.r2.message.stream.entitystream.Writer;
import com.linkedin.r2.netty.common.ChannelPipelineEvent;
import com.linkedin.r2.netty.common.NettyChannelAttributes;
import com.linkedin.r2.netty.common.StreamingTimeout;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.TooLongFrameException;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamWriter
extends ChannelInboundHandlerAdapter
implements Writer {
    private static final Logger LOG = LoggerFactory.getLogger(StreamWriter.class);
    public static final ByteString EOF = ByteString.copy((byte[])new byte[0]);
    private static final int BUFFER_HIGH_WATER_MARK = 24576;
    private static final int BUFFER_LOW_WATER_MARK = 8192;
    private final ChannelHandlerContext _ctx;
    private final List<ByteString> _buffer = new LinkedList<ByteString>();
    private final long _maxContentLength;
    private long _totalBytesWritten = 0L;
    private int _bufferedBytes = 0;
    private boolean _errorRaised = false;
    private volatile WriteHandle _wh;
    private volatile Throwable _failureBeforeInit;

    public StreamWriter(ChannelHandlerContext ctx, long maxContentLength) {
        this._ctx = ctx;
        this._maxContentLength = maxContentLength;
    }

    public void onDataAvailable(ByteString data) {
        if ((long)data.length() + this._totalBytesWritten > this._maxContentLength) {
            this.onError((Throwable)new TooLongFrameException("HTTP content length exceeded " + this._maxContentLength + " bytes."));
            return;
        }
        this._totalBytesWritten += (long)data.length();
        this._buffer.add(data);
        this._bufferedBytes += data.length();
        if (this._bufferedBytes > 24576 && this._ctx.channel().config().isAutoRead()) {
            this._ctx.channel().config().setAutoRead(false);
        }
        if (this._wh != null) {
            this.doWrite();
        }
    }

    public void onError(Throwable throwable) {
        if (this._wh == null) {
            this._failureBeforeInit = throwable;
        } else if (!this._errorRaised) {
            this._wh.error((Throwable)new RemoteInvocationException(throwable));
            this._errorRaised = true;
        }
    }

    public void onInit(WriteHandle wh) {
        this._wh = wh;
        this.refreshStreamLastActiveTime();
    }

    public void onWritePossible() {
        if (this._failureBeforeInit != null) {
            this.onError(this._failureBeforeInit);
            return;
        }
        if (this._ctx.executor().inEventLoop()) {
            this.doWrite();
        } else {
            this._ctx.executor().execute(this::doWrite);
        }
    }

    public void onAbort(Throwable throwable) {
        LOG.error("onAbort: " + throwable.toString());
        this._ctx.fireExceptionCaught(throwable);
    }

    private void doWrite() {
        this.refreshStreamLastActiveTime();
        while (this._wh.remaining() > 0 && !this._buffer.isEmpty()) {
            ByteString data = this._buffer.remove(0);
            if (data == EOF) {
                this._wh.done();
                this._ctx.fireUserEventTriggered((Object)ChannelPipelineEvent.RESPONSE_COMPLETE);
                return;
            }
            this._wh.write(data);
            this._bufferedBytes -= data.length();
            if (!this._ctx.channel().config().isAutoRead() && this._bufferedBytes < 8192) {
                this._ctx.channel().config().setAutoRead(true);
            }
            this.refreshStreamLastActiveTime();
        }
    }

    private void refreshStreamLastActiveTime() {
        StreamingTimeout idleTimeout = (StreamingTimeout)this._ctx.channel().attr(NettyChannelAttributes.STREAMING_TIMEOUT_FUTURE).get();
        if (idleTimeout != null) {
            idleTimeout.refreshLastActiveTime();
        }
    }
}

